-- NI Modding
--
-- author  	Henly20 
-- date  	03-02-2013.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com

FordForce = {};

function FordForce.prerequisitesPresent(specializations)
    return true;
end;

function FordForce:load(xmlFile)

	local rotationRpmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationRpm#index"));
		if rotationRpmNode ~= nil then
        self.rotationRpm = {};
        self.rotationRpm.node = rotationRpmNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#minRot"));
        self.rotationRpm.minRot = {};
        self.rotationRpm.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#maxRot"));
        self.rotationRpm.maxRot = {};
        self.rotationRpm.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationRpm.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#rotTime"), 2)*1000;
        self.rotationRpm.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#touchRotLimit"), 10));
    end;
	local rotationFuelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationFuel#index"));
		if rotationFuelNode ~= nil then
        self.rotationFuel = {};
        self.rotationFuel.node = rotationFuelNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFuel#minRot"));
        self.rotationFuel.minRot = {};
        self.rotationFuel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFuel#maxRot"));
        self.rotationFuel.maxRot = {};
        self.rotationFuel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFuel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFuel#rotTime"), 2)*1000;
        self.rotationFuel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFuel#touchRotLimit"), 10));
    end;
	local rotationPartNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationPartNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationPartNode8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
        self.rotationPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#touchRotLimit"), 10));
    end;
	local rotationPartNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart11#index"));
    if rotationPartNode11 ~= nil then
        self.rotationPart11 = {};
        self.rotationPart11.node = rotationPartNode11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#minRot"));
        self.rotationPart11.minRot = {};
        self.rotationPart11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#maxRot"));
        self.rotationPart11.maxRot = {};
        self.rotationPart11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#rotTime"), 2)*1000;
        self.rotationPart11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#touchRotLimit"), 10));
    end;
	
     self.setRotationSteerLeftActive = SpecializationUtil.callSpecializationsFunction("setRotationSteerLeftActive");
     self.setRotationSteerRightActive = SpecializationUtil.callSpecializationsFunction("setRotationSteerRightActive");
     self.setRotationBrakesActive = SpecializationUtil.callSpecializationsFunction("setRotationBrakesActive");	 
	
	local rotationNodeSteerLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationSteerLeft#index"));
    if rotationNodeSteerLeft ~= nil then
        self.rotationSteerLeft = {};
        self.rotationSteerLeft.node = rotationNodeSteerLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSteerLeft#minRot"));
        self.rotationSteerLeft.minRot = {};
        self.rotationSteerLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSteerLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSteerLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSteerLeft#maxRot"));
        self.rotationSteerLeft.maxRot = {};
        self.rotationSteerLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSteerLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSteerLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSteerLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSteerLeft#rotTime"), 2)*1000;
        self.rotationSteerLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSteerLeft#touchRotLimit"), 10));
    end;
	local rotationNodeSteerRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationSteerRight#index"));
    if rotationNodeSteerRight ~= nil then
        self.rotationSteerRight = {};
        self.rotationSteerRight.node = rotationNodeSteerRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSteerRight#minRot"));
        self.rotationSteerRight.minRot = {};
        self.rotationSteerRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSteerRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSteerRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSteerRight#maxRot"));
        self.rotationSteerRight.maxRot = {};
        self.rotationSteerRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSteerRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSteerRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSteerRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSteerRight#rotTime"), 2)*1000;
        self.rotationSteerRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSteerRight#touchRotLimit"), 10));
    end;
	local rotationNodeBrakes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationBrakes#index"));
    if rotationNodeBrakes ~= nil then
        self.rotationBrakes = {};
        self.rotationBrakes.node = rotationNodeBrakes;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationBrakes#minRot"));
        self.rotationBrakes.minRot = {};
        self.rotationBrakes.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationBrakes.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationBrakes.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationBrakes#maxRot"));
        self.rotationBrakes.maxRot = {};
        self.rotationBrakes.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationBrakes.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationBrakes.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationBrakes.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationBrakes#rotTime"), 2)*1000;
        self.rotationBrakes.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationBrakes#touchRotLimit"), 10));
    end;

	self.rotationSteerLeftActive = false;
	self.rotationSteerRightActive = false;
	self.rotationBrakesActive = false;	
	self.rotationMax8Active = false;
    self.fanNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fan#index"));
	self.toplink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.topLink#index"));
	self.highhitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.highHitch#index"));
	self.drawBar = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drawBar#index"));	
 	setVisibility((self.toplink), false);
 	setVisibility((self.highhitch), true);
	
    local crawlerSound = getXMLString(xmlFile, "vehicle.crawlerSound#file");
    if crawlerSound ~= nil and crawlerSound ~= "" then
        crawlerSound = Utils.getFilename(crawlerSound, self.baseDirectory);
        self.crawlerSound = createSample("crawlerSound");
        loadSample(self.crawlerSound, crawlerSound, false);
        self.crawlerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.crawlerSound#pitchOffset"), 0);
        self.crawlerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.crawlerSound#volume"), 1.0);
        self.crawlerSoundEnabled = false;
    end;
	  
	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;

	local BottomArmNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.bottomArm#rotationNode"));
	self.bottomArm = {};
	self.bottomArm.node = BottomArmNode;
	
	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#node"));
	self.backAttacherJoint.lowRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#lowRot"));
	self.backAttacherJoint.upRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upRot"));
    
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
end;

function FordForce:readStream(streamId, connection)
     self.rotateSteerLeftActive = streamReadBool(streamId);
     if self.rotationSteerLeft ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationSteerLeft.node, x, y, z);
      end;
     if self.rotationSteerRight ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationSteerRight.node, x, y, z);
      end;
     self.rotateBrakesActive = streamReadBool(streamId);
     if self.rotationBrakes ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationBrakes.node, x, y, z);
      end;
end;
  
function FordForce:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateSteerLeftActive);
		if self.rotationSteerLeft ~= nil then
          local x, y, z = getRotation(self.rotationSteerLeft.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationSteerRight ~= nil then
          local x, y, z = getRotation(self.rotationSteerRight.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
      streamWriteBool(streamId, self.rotateBrakesActive);
		if self.rotationBrakes ~= nil then
          local x, y, z = getRotation(self.rotationBrakes.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function FordForce:keyEvent(unicode, sym, modifier, isDown)

end;

function FordForce:update(dt)
    if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		if InputBinding.isPressed(InputBinding.STEERLEFT) then
			self:setRotationSteerLeftActive(true);	
			else
			self:setRotationSteerLeftActive(false);				
		end;
		if InputBinding.isPressed(InputBinding.STEERRIGHT) then
			self:setRotationSteerRightActive(true);	
			else
			self:setRotationSteerRightActive(false);	
		end;		
	end;	
	
	if self:getIsActive() then	
        if self.crawlerSound ~= nil then
            if self.lastSpeed*3600 > 1 then
                if not self.crawlerSoundEnabled and self:getIsActiveForSound() then
                    playSample(self.crawlerSound, 0, self.crawlerSoundVolume, 0);
                    setSamplePitch(self.crawlerSound, self.crawlerSoundPitchOffset);
                    self.crawlerSoundEnabled = true;
                end;
                elseif self.lastSpeed*3600 < 1 then
					if self.crawlerSoundEnabled then
                        stopSample(self.crawlerSound);
                        self.crawlerSoundEnabled = false;
					end;
            end;
         end;

		 inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
		
		if self.isEntered ~= nil then
			if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		

				self.rotationMax8Active = true;
			else

				self.rotationMax8Active = false;
			end;
		end;
		if self.brakeLightsVisibility then
			self:setRotationBrakesActive(true);	
		else
			self:setRotationBrakesActive(false);	
		end;			
	
		local maxrpmneedle = 1800;
		if self.rotationRpm ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationRpm.node);
			y = ((self.rotationRpm.maxRot[2] - self.rotationRpm.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm+400) + self.rotationRpm.minRot[2];
			setRotation(self.rotationRpm.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationRpm.node, 0, 0 ,0);
		end;
		local maxfuelguage = 75;
		if self.rotationFuel ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationFuel.node);
			y = ((self.rotationFuel.maxRot[2] - self.rotationFuel.minRot[2]) / maxfuelguage) * self.fuelFillLevel + self.rotationFuel.minRot[2];
			setRotation(self.rotationFuel.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationFuel.node, 0, 0 ,0);
		end;
		if self.rotationPart8 ~= nil then
			local x, y, z = getRotation(self.rotationPart8.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.rotationMax8Active);
			setRotation(self.rotationPart8.node, unpack(newRot));
		end;
		local maxhandthrottle = 1800;
		if self.rotationPart11 ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationPart11.node);
			y = ((self.rotationPart11.maxRot[2] - self.rotationPart11.minRot[2]) / maxhandthrottle) * (self.motor.lastMotorRpm+400) + self.rotationPart11.minRot[2];
			setRotation(self.rotationPart11.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart11.node, 0, 0 ,0);
		end;
		if self.rotationSteerLeft ~= nil then
			local x, y, z = getRotation(self.rotationSteerLeft.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationSteerLeft.maxRot, self.rotationSteerLeft.minRot, 3, self.rotationSteerLeft.rotTime, dt, not self.rotationSteerLeftActive);
			setRotation(self.rotationSteerLeft.node, unpack(newRot));
		end;
		if self.rotationSteerRight ~= nil then
			local x, y, z = getRotation(self.rotationSteerRight.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationSteerRight.maxRot, self.rotationSteerRight.minRot, 3, self.rotationSteerRight.rotTime, dt, not self.rotationSteerRightActive);
			setRotation(self.rotationSteerRight.node, unpack(newRot));
		end;
		if self.rotationBrakes ~= nil then
			local x, y, z = getRotation(self.rotationBrakes.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationBrakes.maxRot, self.rotationBrakes.minRot, 3, self.rotationBrakes.rotTime, dt, not self.rotationBrakesActive);
			setRotation(self.rotationBrakes.node, unpack(newRot));
		end;			
	
		if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
			rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
			setRotation(self.Lifter.node, rBBArmX*1.05, 0, 0);
		end;
		if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
			setRotation(self.LifterArm.node, 0.05-rBBArmX*1.1, 0, 0);
		end;
			
	end;
		if self:getIsActive() then			
			self.setHydraulicTime = 30;	
		end;

		if self.setHydraulicTime > 0 then
			for k,v in pairs(self.hydraulics) do 
				self:setHydraulicDirection(k);
			end;
			self.setHydraulicTime = self.setHydraulicTime - 1;
		end;
		if self.fanNode ~= nil and self.isMotorStarted then 
			 rotate(self.fanNode, 0, 0, self.motor.lastMotorRpm*4);
		end;			
end;

function FordForce:updateTick(dt)
	if self:getIsActive() then	
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm			
			local x, y, z = getRotation(self.attacherJoints[1].bottomArm.rotationNode);
			setRotation(self.backHydraulic.rootArm, x, y, z);	
		end;		
	end;
	
end;

function FordForce:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return true;
end;

function FordForce:draw()
  
end;

function FordForce:onEnter()

end;

function FordForce:onLeave()
     FordForce.onDeactivateSounds(self);
end;

function FordForce:delete()
     if self.crawlerSound ~= nil then
         delete(self.crawlerSound);
     end;
end;

function FordForce:onDeactivateSounds()
      if self.crawlerSoundEnabled then
          stopSample(self.crawlerSound);
          self.crawlerSoundEnabled = false;
      end;
end;

function FordForce:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function FordForce:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FordForce:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
			if jointIndex == 1 then
				setVisibility((self.toplink), true);
				setVisibility((self.highhitch), false);	
				setRotation(self.drawBar, 0, math.rad(-15), 0);				
			end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setRotation(self.attacherJoints[1].bottomArm.rotationNode, self.backAttacherJoint.lowRot, 0, 0);
			setRotation(self.backAttacherJoint.node, -self.backAttacherJoint.lowRot, 0, 0);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setRotation(self.attacherJoints[1].bottomArm.rotationNode, self.backAttacherJoint.lowRot, 0, 0);
			setRotation(self.backAttacherJoint.node, -self.backAttacherJoint.lowRot, 0, 0);
		end;
	end;
		
	self.updateJoint = true;
end;

function FordForce:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		setVisibility((self.toplink), false);
		setVisibility((self.highhitch), true);
		setRotation(self.drawBar, 0, math.rad(0), 0);			
	elseif jointIndex == 2 or jointIndex == 3 then
		setRotation(self.attacherJoints[1].bottomArm.rotationNode, 0, 0, 0);
		setRotation(self.backAttacherJoint.node, 0, 0, 0);
	end;
end;

function FordForce:setRotationSteerLeftActive(rotationSteerLeftActive, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetSteerLeftRotationEvent:new(self, rotationSteerLeftActive), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetSteerLeftRotationEvent:new(self, rotationSteerLeftActive));
          end;
      end;
      self.rotationSteerLeftActive = rotationSteerLeftActive;
end;

function FordForce:setRotationSteerRightActive(rotationSteerRightActive, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetSteerRightRotationEvent:new(self, rotationSteerRightActive), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetSteerRightRotationEvent:new(self, rotationSteerRightActive));
          end;
      end;
      self.rotationSteerRightActive = rotationSteerRightActive;
end;

function FordForce:setRotationBrakesActive(rotationBrakesActive, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetBrakesRotationEvent:new(self, rotationBrakesActive), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetBrakesRotationEvent:new(self, rotationBrakesActive));
          end;
      end;
      self.rotationBrakesActive = rotationBrakesActive;
end;

SetSteerLeftRotationEvent = {};
SetSteerLeftRotationEvent_mt = Class(SetSteerLeftRotationEvent, Event);
  
InitEventClass(SetSteerLeftRotationEvent, "SetSteerLeftRotationEvent");
  
function SetSteerLeftRotationEvent:emptyNew()
      local self = Event:new(SetSteerLeftRotationEvent_mt);
      self.className="SetSteerLeftRotationEvent";
      return self;
 end;

function SetSteerLeftRotationEvent:new(object, rotationSteerLeftActive)
      local self = SetSteerLeftRotationEvent:emptyNew()
      self.object = object;
      self.rotationSteerLeftActive = rotationSteerLeftActive;
      return self;
end;
 
function SetSteerLeftRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationSteerLeftActive = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetSteerLeftRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationSteerLeftActive);
end;
 
function SetSteerLeftRotationEvent:run(connection)
      self.object:setRotationSteerLeftActive(self.rotationSteerLeftActive, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetSteerLeftRotationEvent:new(self.object, self.rotationSteerLeftActive), nil, connection, self.object);
      end;
end;

SetSteerRightRotationEvent = {};
SetSteerRightRotationEvent_mt = Class(SetSteerRightRotationEvent, Event);
  
InitEventClass(SetSteerRightRotationEvent, "SetSteerRightRotationEvent");
  
function SetSteerRightRotationEvent:emptyNew()
      local self = Event:new(SetSteerRightRotationEvent_mt);
      self.className="SetSteerRightRotationEvent";
      return self;
 end;

function SetSteerRightRotationEvent:new(object, rotationSteerRightActive)
      local self = SetSteerRightRotationEvent:emptyNew()
      self.object = object;
      self.rotationSteerRightActive = rotationSteerRightActive;
      return self;
end;
 
function SetSteerRightRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationSteerRightActive = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetSteerRightRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationSteerRightActive);
end;
 
function SetSteerRightRotationEvent:run(connection)
      self.object:setRotationSteerRightActive(self.rotationSteerRightActive, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetSteerRightRotationEvent:new(self.object, self.rotationSteerRightActive), nil, connection, self.object);
      end;
end;

SetBrakesRotationEvent = {};
SetBrakesRotationEvent_mt = Class(SetBrakesRotationEvent, Event);
  
InitEventClass(SetBrakesRotationEvent, "SetBrakesRotationEvent");
  
function SetBrakesRotationEvent:emptyNew()
      local self = Event:new(SetBrakesRotationEvent_mt);
      self.className="SetBrakesRotationEvent";
      return self;
 end;

function SetBrakesRotationEvent:new(object, rotationBrakesActive)
      local self = SetBrakesRotationEvent:emptyNew()
      self.object = object;
      self.rotationBrakesActive = rotationBrakesActive;
      return self;
end;
 
function SetBrakesRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationBrakesActive = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetBrakesRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationBrakesActive);
end;
 
function SetBrakesRotationEvent:run(connection)
      self.object:setRotationBrakesActive(self.rotationBrakesActive, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetBrakesRotationEvent:new(self.object, self.rotationBrakesActive), nil, connection, self.object);
      end;
end;