--
-- BuyableFloatationWheelsAttacher
-- Specialization for Buyable Floatation Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

BuyableFloatationWheelsAttacher = {};

function BuyableFloatationWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableFloatationWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableFloatationWheels = {};
	self.buyableFloatationWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#floatationWheelsCheckString"), "standart");
	self.buyableFloatationWheels.floatationWheels = nil;
	self.buyableFloatationWheels.wheelsInRange = nil;	
end;

function BuyableFloatationWheelsAttacher:delete()
	if self.buyableFloatationWheels.floatationWheels ~= nil then
		self.buyableFloatationWheels.floatationWheels:disassembleWheels(true);
	end;
end;

function BuyableFloatationWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableFloatationWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableFloatationWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableFloatationWheels;
		if wheels.wheelsInRange ~= nil and self.movingDirection == 0 then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_WHEELS_ATTACH) then
					if wheels.floatationWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.floatationWheelUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableFloatationWheelsAttacher:draw()
	local wheels = self.buyableFloatationWheels;
	if wheels.wheelsInRange ~= nil and self.movingDirection == 0 then
		if wheels.floatationWheels ~= nil then
			if wheels.wheelsInRange.floatationWheelUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFloatationWheels_disassemble"), InputBinding.BUYABLE_WHEELS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.floatationWheelUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFloatationWheels_assemble"), InputBinding.BUYABLE_WHEELS_ATTACH);
			end;
		end;
	end;
end;

function BuyableFloatationWheelsAttacher:onAssembling(buyableFloatationWheels)
	self.buyableFloatationWheels.floatationWheels = buyableFloatationWheels;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(false);
	end;
end;

function BuyableFloatationWheelsAttacher:onDisassembling()
	self.buyableFloatationWheels.floatationWheels = nil;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(true);
	end;
end;