--
-- BoardwallEvent
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		01/08/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

BoardwallEvent = {};
BoardwallEvent_mt = Class(BoardwallEvent, Event);

InitEventClass(BoardwallEvent, "BoardwallEvent");

function BoardwallEvent:emptyNew()
    local self = Event:new(BoardwallEvent_mt);
    self.className="BoardwallEvent";
    return self;
end;

function BoardwallEvent:new(vehicle, isVisible)
    local self = BoardwallEvent:emptyNew()
    self.vehicle = vehicle;
	self.isVisible = isVisible;
    return self;
end;

function BoardwallEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isVisible = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BoardwallEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isVisible);
end;

function BoardwallEvent:run(connection)
	self.vehicle:setIsBoardwallVisible(self.isVisible, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(BoardwallEvent:new(self.vehicle, self.isVisible), nil, connection, self.vehicle);
	end;
end;

function BoardwallEvent.sendEvent(vehicle, isVisible, noEventSend)
	if vehicle.boardWall.isVisible ~= isVisible then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(BoardwallEvent:new(vehicle, isVisible), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(BoardwallEvent:new(vehicle, isVisible));
			end;
		end;
	end;
end;