--
-- Tebbe ST 450
-- Specialization for Tebbe ST 450
--
-- @author  	Mofa-Killer (BM-Modding)
-- @version 	v1.0
-- @date  		01/05/12
--

TebbeST450 = {};

function TebbeST450.prerequisitesPresent(specializations)
    return true;
end;

function TebbeST450:load(xmlFile)
    self.hydraulicHose1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoses#hose1"));
    self.hydraulicHose2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoses#hose2"));
    self.hydraulicHose3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoses#hose3"));
    self.hydraulicHose4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoses#hose4"));
    self.hydraulicHose5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoses#hose5"));
    self.hydraulicHose6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoses#hose6"));
    
    local slatFloorAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slatFloor#rootNode"));
    self.slatFloorAnimCharSet = 0;
    if slatFloorAnimRootNode ~= nil and slatFloorAnimRootNode ~= 0 then
        self.slatFloorAnimCharSet = getAnimCharacterSet(slatFloorAnimRootNode);
        if self.slatFloorAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.slatFloorAnimCharSet, getXMLString(xmlFile, "vehicle.slatFloor#clip"));
            assignAnimTrackClip(self.slatFloorAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.slatFloorAnimCharSet, 0, true);
            local slatFloorAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.slatFloor#speedScale"), 1);
			setAnimTrackSpeedScale(self.slatFloorAnimCharSet, 0, slatFloorAnimSpeedScale);
            self.slatFloorAnimDuration = getAnimClipDuration(self.slatFloorAnimCharSet, clip);
        end;
    end;
    self.slatFloorChains = {};
	self.slatFloorChains.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slatFloorChains#index"));
	self.slatFloorChains.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.slatFloorChains#unloadingSpeed"), 0.001);
	self.slatFloorChains.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.slatFloorChains#unloadingDirection"), 1);
	setShaderParameter(self.slatFloorChains.node, "movingDirection", 0,0,0,0,false);    
end;

function TebbeST450:postLoad(xmlFile)
    if self.hydraulicHose1 ~= nil then
        link(getRootNode(), self.hydraulicHose1);
		setTranslation(self.hydraulicHose1, 0,0,0);
    end;
    
    if self.hydraulicHose2 ~= nil then
        link(getRootNode(), self.hydraulicHose2);
		setTranslation(self.hydraulicHose2, 0,0,0);
    end;
    
    if self.hydraulicHose3 ~= nil then
        link(getRootNode(), self.hydraulicHose3);
		setTranslation(self.hydraulicHose3, 0,0,0);
    end;
    
    if self.hydraulicHose4 ~= nil then
        link(getRootNode(), self.hydraulicHose4);
		setTranslation(self.hydraulicHose4, 0,0,0);
    end;
    
    if self.hydraulicHose5 ~= nil then
        link(getRootNode(), self.hydraulicHose5);
		setTranslation(self.hydraulicHose5, 0,0,0);
    end;
    
    if self.hydraulicHose6 ~= nil then
        link(getRootNode(), self.hydraulicHose6);
		setTranslation(self.hydraulicHose6, 0,0,0);
    end;
end;

function TebbeST450:delete()
    if self.hydraulicHose1 ~= nil then
        delete(self.hydraulicHose1);
    end;
    
    if self.hydraulicHose2 ~= nil then
        delete(self.hydraulicHose2);
    end;
    
    if self.hydraulicHose3 ~= nil then
        delete(self.hydraulicHose3);
    end;
    
    if self.hydraulicHose4 ~= nil then
        delete(self.hydraulicHose4);
    end;
    
    if self.hydraulicHose5 ~= nil then
        delete(self.hydraulicHose5);
    end;
    
    if self.hydraulicHose6 ~= nil then
        delete(self.hydraulicHose6);
    end;
end;

function TebbeST450:update(dt)
    if self:getIsActive() then
		Cylindered.updateMovingPart(self, self.movingParts[1]);

        for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
		
		if self.tipState == Trailer.TIPSTATE_OPEN then
		    enableAnimTrack(self.slatFloorAnimCharSet, 0);
		    setShaderParameter(self.slatFloorChains.node, "movingDirection", self.slatFloorChains.unloadingDirection*self.slatFloorChains.unloadingSpeed,0,0,0,false);
        else
            disableAnimTrack(self.slatFloorAnimCharSet, 0);
            setShaderParameter(self.slatFloorChains.node, "movingDirection", 0,0,0,0,false);
        end;		  
	end;   
end;

function TebbeST450:updateTick(dt)
end;

function TebbeST450:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TebbeST450:keyEvent(unicode, sym, modifier, isDown)
end;

function TebbeST450:draw()
end;