--
-- WatsonRoller
-- Specialization Watson Roller.
--
-- @author  	PeterJ - FS_UK modteam
-- @version 	v1.0
-- @date  		15/04/2013
--

WatsonRoller = {};

function WatsonRoller.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function WatsonRoller:load(xmlFile)

	self.setRollerAnimation = SpecializationUtil.callSpecializationsFunction("setRollerAnimation");
	self.rollerAnimation = getXMLString(xmlFile, "vehicle.rollerAnimation#animationName");
	self.isRollerAnimOn = false;
	
	self.rollers = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.wheels.roller(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local fakeWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
		if fakeWheel ~= nil then
			table.insert(self.rollers, {node=fakeWheel, speed=speed});
		end;
		i = i + 1;
	end;
  
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
   
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;

	self.isTurnedOn = false;

	self.fruitTypes = {};
	local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
	if fruitTypes ~= nil then
		local types = Utils.splitString(" ", fruitTypes);
		for k,v in pairs(types) do
			local desc = FruitUtil.fruitTypes[v];
			if desc ~= nil then
				self.fruitTypes[desc.index] = true;
			end;
		end;
	end;

	self.groundParticleSystems = {};
	local psName = "vehicle.groundParticleSystem";
	Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, psName, self.components, false, nil, self.baseDirectory)
	self.groundParticleSystemActive = false;
end;

function WatsonRoller:delete()
	Utils.deleteParticleSystem(self.groundParticleSystems);
end;

function WatsonRoller:readStream(streamId, connection)
    self:setRollerAnimation(streamReadBool(streamId), true);
	local turnedOn = streamReadBool(streamId);
	self:setIsTurnedOn(turnedOn, true);
end;

function WatsonRoller:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isRollerAnimOn);
	streamWriteBool(streamId, self.isTurnedOn);
end;

function WatsonRoller:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WatsonRoller:keyEvent(unicode, sym, modifier, isDown)
end;

function WatsonRoller:update(dt)

	if self.rollers ~= nil then
		for _, fakeWheel in pairs(self.rollers) do
			local x,y,z = getRotation(self.wheels[1].driveNode);	
			setRotation(fakeWheel.node, x*fakeWheel.speed, 0, 0);
		end;
	end;
	if self.playerInRange then
		if not self:getIsActive() and (not self.isAttached and not self.isImplementAttached) then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setRollerAnimation(not self.isRollerAnimOn);
			end;
			if self.isRollerAnimOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("fold_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("unfold_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;
end;

function WatsonRoller:updateTick(dt)
	if self.movingDirection ~= 0 then
		if not self.isTurnedOn then	
			self:setIsTurnedOn(true);
		end;
	else
		if self.isTurnedOn then	
			self:setIsTurnedOn(false);
		end;
	end;
	
	if self:getIsActive() then
		if self.isTurnedOn then	
			if self.isServer then
				local cuttingAreasSend = {};
				for _,area in pairs(self.cuttingAreas) do
					if self:getIsAreaActive(area) then
						local x,_,z = getWorldTranslation(area.start);
						if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
							local x1,_,z1 = getWorldTranslation(area.width);
							local x2,_,z2 = getWorldTranslation(area.height);
							table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
						else
							--print("you dont own this filed");
						end;
					end;
				end;
				if (table.getn(cuttingAreasSend) > 0) then
					for fruitType,_ in pairs(self.fruitTypes) do
						local lastCutterArea, realArea = CutterAreaEvent.runLocally(cuttingAreasSend, fruitType);
						if lastCutterArea > 0 then
							g_server:broadcastEvent(CutterAreaEvent:new(cuttingAreasSend, fruitType));
							if self.lastCutterAreaBiggerZero ~= self.lastCutterAreaBiggerZeroSent then
								self:raiseDirtyFlags(self.cutterGroundFlag);
								self.lastCutterAreaBiggerZeroSent = self.lastCutterAreaBiggerZero;
							end;
						end;
					end;
					SprayerAreaEvent.runLocally(cuttingAreasSend);
					g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
				end;
				if not self.groundParticleSystemActive then
					self.groundParticleSystemActive = true;
					Utils.setEmittingState(self.groundParticleSystems, true);
				end;
			end;
		else
			if self.groundParticleSystemActive then
				self.groundParticleSystemActive = false;
				Utils.setEmittingState(self.groundParticleSystems, false);
			end;
		end;
	end;
	if g_currentMission.player ~= nil and self.rollerAnimation ~= nil then
		local nearestDistance = 2.5;
		local x1,y1,z1 = getWorldTranslation(self.rootNode);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
end;

function WatsonRoller:draw()
end;

function WatsonRoller:onAttach(attacherVehicle)
	self.isAttached = true;
end;
 
function WatsonRoller:onDetach()
	self.isAttached = false;
	if self.groundParticleSystemActive then
		self.groundParticleSystemActive = false;
		Utils.setEmittingState(self.groundParticleSystems, false);
	end;
	self:setIsTurnedOn(false);
end;

function WatsonRoller:attachImplement(implement)
	self.isImplementAttached = true;
end;

function WatsonRoller:detachImplement(implementIndex)
	self.isImplementAttached = false;
end;

function WatsonRoller:setRollerAnimation(isRollerAnimOn,noEventSend)
	SetRollerAnimEvent.sendEvent(self, isRollerAnimOn, noEventSend);
	self.isRollerAnimOn = isRollerAnimOn;
	if self.isRollerAnimOn then
		if self.rollerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rollerAnimation, 1, nil, true);
		end;
	else
		if self.rollerAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rollerAnimation, -1, nil, true);
		end;
	end;
end;

function WatsonRoller:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
end;


SetRollerAnimEvent = {};
SetRollerAnimEvent_mt = Class(SetRollerAnimEvent, Event);

InitEventClass(SetRollerAnimEvent, "SetRollerAnimEvent");

function SetRollerAnimEvent:emptyNew()
    local self = Event:new(SetRollerAnimEvent_mt);
    self.className="SetRollerAnimEvent";
    return self;
end;

function SetRollerAnimEvent:new(vehicle, isRollerAnimOn)
    local self = SetRollerAnimEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRollerAnimOn = isRollerAnimOn;
    return self;
end;

function SetRollerAnimEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRollerAnimOn = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRollerAnimEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRollerAnimOn);
end;

function SetRollerAnimEvent:run(connection)   
	self.vehicle:setRollerAnimation(self.isRollerAnimOn, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRollerAnimEvent:new(self.vehicle, self.isRollerAnimOn), nil, connection, self.vehicle);
    end;
end;

function SetRollerAnimEvent.sendEvent(vehicle, isRollerAnimOn, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRollerAnimEvent:new(vehicle, isRollerAnimOn), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRollerAnimEvent:new(vehicle, isRollerAnimOn));
		end;
	end;
end;