ESLimiterEvent = {};
ESLimiterEvent_mt = Class(ESLimiterEvent, Event);

InitEventClass(ESLimiterEvent, "ESLimiterEvent");

function ESLimiterEvent:emptyNew()
    local self = Event:new(ESLimiterEvent_mt);
    self.className="ESLimiterEvent";
    return self;
end;

function ESLimiterEvent:new(vehicle, level, percentage)
    local self = ESLimiterEvent:emptyNew()
    self.vehicle = vehicle;
	self.level = level;
	self.percentage = percentage;
    return self;
end;

function ESLimiterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.level = streamReadInt8(streamId);
	self.percentage = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ESLimiterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.level);
	streamWriteInt8(streamId, self.percentage);
end;

function ESLimiterEvent:run(connection)
	self.vehicle:setNewLimit(self.level, self.percentage, true);
end;

function ESLimiterEvent.sendEvent(vehicle, level, percentage, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			-- no need to broadcast the event: only the server need the information
		else
			g_client:getServerConnection():sendEvent(ESLimiterEvent:new(vehicle, level, percentage));
		end;
	end;
end;