-- by modelleicher
-- www.schwabenmodding.bplaced.net


FENDT_FAVORIT_4S = {};

function FENDT_FAVORIT_4S.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function FENDT_FAVORIT_4S:load(xmlFile)
	self.setTwinState = FENDT_FAVORIT_4S.setTwinState;
	self.setWWState = FENDT_FAVORIT_4S.setWWState;
		
	self.twin1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FendtFavorit4s.Zwillingsreifen#twin1"));
	self.tinw2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FendtFavorit4s.Zwillingsreifen#twin2"));
	self.twin1mount = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FendtFavorit4s.Zwillingsreifen#twin1Mount"));
	self.twin2mount = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FendtFavorit4s.Zwillingsreifen#twin2Mount"));
	
	self.wheelweight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FendtFavorit4s.Felgengewichte#w1"));
	self.wheelweight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FendtFavorit4s.Felgengewichte#w2"));
	
	self.wheelweightState = false;
	self.twinState = 0;

	self.showWarning1 = false;
	self.showWarning2 = false;
	
	self:setTwinState(0);
	self:setWWState(false);
end;
function FENDT_FAVORIT_4S:setTwinState(state, noEventSend)
	setTwinStateEvent.sendEvent(self, state, noEventSend);
	self.twinState = state;
	local state1, state2 = false;
	if state == 0 then
		state1 = false;
		state2 = false;
	elseif state == 1 then
		state1 = true;
		state2 = false;
	elseif state == 3 then
		state1 = true;
		state2 = true;
	end;
	setVisibility(self.twin1, state2)
	setVisibility(self.tinw2, state2)
	setVisibility(self.twin1mount, state1)
	setVisibility(self.twin2mount, state1)	
end;
function FENDT_FAVORIT_4S:setWWState(state, noEventSend)
	setWWStateEvent.sendEvent(self, state, noEventSend);
	self.wheelweightState = state;
	setVisibility(self.wheelweight1, state)
	setVisibility(self.wheelweight2, state)	
end;

function FENDT_FAVORIT_4S:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ToggleTwin) then
			if not self.wheelweightState then
				self.twinState = self.twinState +1
			    if self.twinState == 3 then
					self.twinState = 0;
				end;
				self:setTwinState(self.twinState);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.ToggleWW) then
			if self.twinState < 1 then
				self:setWWState(not self.wheelweightState);
			end;
		end;		
	end;
end;

function FENDT_FAVORIT_4S:draw()
	if self.twinState < 1 then
		g_currentMission:addHelpButtonText(g_i18n:getText("ToggleWW"), InputBinding.ToggleWW);
	end;
	if not self.wheelweightState then
		g_currentMission:addHelpButtonText(g_i18n:getText("ToggleTwin"), InputBinding.ToggleTwin);	
	end;
end;
function FENDT_FAVORIT_4S:delete()
end;
function FENDT_FAVORIT_4S:keyEvent(unicode, sym, modifier, isDown)
end;
function FENDT_FAVORIT_4S:mouseEvent(posX, posY, isDown, isUp, button)
end;


setTwinStateEvent = {};
setTwinStateEvent_mt = Class(setTwinStateEvent, Event);
InitEventClass(setTwinStateEvent, "setTwinStateEvent");

function setTwinStateEvent:emptyNew()  
    local self = Event:new(setTwinStateEvent_mt );
    self.className="setTwinStateEvent";
    return self;
end;
function setTwinStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function setTwinStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadInt32(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;
function setTwinStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteInt32(streamId, self.state );   
end;
function setTwinStateEvent:run(connection) 
    self.vehicle:setTwinState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(setTwinStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;
function setTwinStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then   
			g_server:broadcastEvent(setTwinStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(setTwinStateEvent:new(vehicle, state));
		end;
	end;
end;

setWWStateEvent = {};
setWWStateEvent_mt = Class(setWWStateEvent, Event);
InitEventClass(setWWStateEvent, "setWWStateEvent");

function setWWStateEvent:emptyNew()  
    local self = Event:new(setWWStateEvent_mt );
    self.className="setWWStateEvent";
    return self;
end;
function setWWStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function setWWStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;
function setWWStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;
function setWWStateEvent:run(connection) 
    self.vehicle:setWWState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(setWWStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;
function setWWStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then   
			g_server:broadcastEvent(setWWStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(setWWStateEvent:new(vehicle, state));
		end;
	end;
end;