--
-- FrontloaderAttacher
-- Specialization for FrontloaderAttacher
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		26/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

FendtFrontloader = {};

function FendtFrontloader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function FendtFrontloader:load(xmlFile)	
	
	local x,y,z = getCenterOfMass(self.components[1].node);
	self.centerOfMassDetachedCollision = {x,y,z};
	
	self.frontloader = {};	
	self.frontloader.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontloader#index"));
	self.frontloader.detachLimit = math.rad(getXMLFloat(xmlFile, "vehicle.frontloader#detachLimit"));
	
	self.isImplementAttached = false;
	self.printWarningTime = 0;
	self.attacherVehicleImplCount = 0;
	
	self.doUpdateCount = 3;
end;

function FendtFrontloader:delete()
end;

function FendtFrontloader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FendtFrontloader:keyEvent(unicode, sym, modifier, isDown)
end;

function FendtFrontloader:update(dt)
	if self.doUpdateCount > 0 then
		for _, tool in ipairs(self.movingTools) do
			Cylindered.setDirty(self, tool);
		end;
		self.doUpdateCount = self.doUpdateCount - 1;
	end;

	if self:getIsActive() then
		local newImplCount = 0;
		if self.attacherVehicle ~= nil then
			newImplCount = table.getn(self.attacherVehicle.attachedImplements);
		end;
		if not self.allowsDetaching and g_currentMission.attachableInMountRange == nil and self:getIsActiveForInput() then				
			if self.attacherVehicleImplCount == newImplCount then	
				if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
					if InputBinding.hasEvent(InputBinding.ATTACH) then
						if not self.isImplementAttached or (self.isImplementAttached and Input.isKeyPressed(Input.KEY_shift)) then
							self.printWarningTime = self.time + 1000;
						end;
						if not Input.isKeyPressed(Input.KEY_shift) then
							self.isImplementAttached = false;
						end;
					end;
				end;
			end;
		end;
		
		self.attacherVehicleImplCount = newImplCount;
	end;
end;

function FendtFrontloader:updateTick(dt)
	if self:getIsActive() then
		local x,_,_ = getRotation(self.frontloader.node);
		self.allowsDetaching = x > self.frontloader.detachLimit;
	end;
end;

function FendtFrontloader:draw()
	if self.printWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("detach_Error"), 0.018, 0.033);
	end;
end;

function FendtFrontloader:onAttach(attacherVehicle)
	self.attacherVehicleImplCount = table.getn(attacherVehicle.attachedImplements);
	setCenterOfMass(self.components[2].node, 0, 0.38, -2.26);
	local x,y,z = getCenterOfMass(attacherVehicle.rootNode);
	setVisibility(self.frontloader.supportArms, false);	
	self.runOnce = true;
end;

function FendtFrontloader:onDetach()
	self.attacherVehicleImplCount = 0;
	local x,y,z = unpack(self.centerOfMassDetachedCollision);
	setCenterOfMass(self.components[2].node, 0, 0, 0);
	setVisibility(self.frontloader.supportArms, true);
end;


function FendtFrontloader:attachImplement(implement)
	self.isImplementAttached = true;
end;