--
-- BEL3fwd
-- Erweiterung von BeleuchtungV3.x um eine Fahrtrichtungsanzeige fr vorwrts
-- Addon to BeleuchtungV3.x - adds a control-light for forward direction
--
-- @author  Sven777b
-- @date  20.08.2012
--
-- moddesc : <specialization name="bel3fwd" className="BEL3fwd" filename="bel3fwd.lua"/>
-- lightsaddon entry :  <light type="forward" index="27" />

BEL3fwd = {};

function BEL3fwd.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(BEL3, specializations);
end;

function BEL3fwd:update(dt)
	if self.isServer and self:getIsActive() then
		if self.B3.forward ~= nil then
			local iR = (self.movingDirection*self.B3.md) > 0;
			if self.B3.forward[1].a ~= iR then 		
				self:setState("forward",iR);
			end;
		end;
	end;
end;

function BEL3fwd:onLeave() 
	if self.B3.forward then
		if self.B3.forward[1].a then
			self:setState("forward",false);
		end;
	end;
end;

function BEL3fwd:load(xmlFile)
end;

function BEL3fwd:delete()
end;

function BEL3fwd:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BEL3fwd:keyEvent(unicode, sym, modifier, isDown)
end;

function BEL3fwd:draw()
end;
