--
-- FendtGTA380
-- Specialization for FendtGTA380
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		21/11/12
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--				v3.0 - converted to 2013 and some bugfixes
--
-- free for noncommerical-usage
--

Vehicle.registerJointType("attachableFrontloader");

Fendt380GTATurbo = {};

function Fendt380GTATurbo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt380GTATurbo:load(xmlFile)

	self.setFenderVisibility = SpecializationUtil.callSpecializationsFunction("setFenderVisibility");
	
	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#back"));
	self.backAttacherJoint.upYPos = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upY"), 0);
	self.backAttacherJoint.downYPos = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#downY"), 0);	
	local x,y,z = getTranslation(self.backAttacherJoint.node);
	self.backAttacherJoint.xPos = x;
	self.backAttacherJoint.zPos = z;	
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));
	setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.upYPos, self.backAttacherJoint.zPos);
	
	self.fenders = {};
	self.fenders.left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index"));
	self.fenders.right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index2"));
		
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
	
    self.drivingShaft = {};
	self.drivingShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));
	self.drivingShaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingShaft#speedFactor"), 2);
	
	-- disable toparm
	setVisibility(self.attacherJoints[2].topArm.rotationNode, false);
end;

function Fendt380GTATurbo:delete()
end;

function Fendt380GTATurbo:readStream(streamId, connection)
end;

function Fendt380GTATurbo:writeStream(streamId, connection)
end;

function Fendt380GTATurbo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt380GTATurbo:keyEvent(unicode, sym, modifier, isDown)
end;

function Fendt380GTATurbo:update(dt)
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then			
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then 
						self.nextAction = false;
					end;
				end;
			end;		
		end;
		
		local x,y,z = getRotation(self.wheels[1].driveNode);
		setRotation(self.drivingShaft.node, 0 ,0, x*self.drivingShaft.speedFactor);	
	end;
end;

function Fendt380GTATurbo:updateTick(dt)

	if self:getIsActive() then	
		if self.doLowering then	
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];	
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;			
			if self.loweringDone then
				self.delay = self.delay - dt;				
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;
	end;
end;

function Fendt380GTATurbo:draw()	
	if self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;
end;

function Fendt380GTATurbo:attachImplement(implement)
	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;		
		-- index 1 defines back hydraulic
		if jointIndex == 1 then
			setVisibility(self.backAttacherJoint.node, false);
		elseif jointIndex == 2 then
			setVisibility(self.frontAttacherJoint.node, false);
			setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 4 then
			setVisibility(self.backAttacherJoint.node, true);	
			setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.upYPos, self.backAttacherJoint.zPos);	
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 5 then
			setVisibility(self.backAttacherJoint.node, true);	
			setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.downYPos, self.backAttacherJoint.zPos);
		end;
	end;	
end;

function Fendt380GTATurbo:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;	
	end;
	if jointIndex == 1 then
		setVisibility(self.backAttacherJoint.node, true);
	elseif jointIndex == 2 then
		setVisibility(self.frontAttacherJoint.node, true);
		setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, false);
	elseif jointIndex == 5 then
		setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.upYPos, self.backAttacherJoint.zPos);
	end;
end;

function Fendt380GTATurbo:setFenderVisibility(isVisible)
	setVisibility(self.fenders.left, isVisible);
	setVisibility(self.fenders.right, isVisible);
end;