--
-- Fendt936
--
--
--

Fendt936 = {};

function Fendt936.prerequisitesPresent(specializations)
    return true; 
end;

function Fendt936:load(xmlFile)

	
	--self.isSelectable = true;
	--self.mtReactivated = false;
	
	--###
	for i,j in pairs(self.mc[1]) do
		local x,y,z = getTranslation(self.movingTools[j].node);
		self.movingTools[j].origPos = {x,y,z};		
	end;		
	
	
	--###
	--[[
	<fenderRot>
		<left index="0>11" rotIndex="0>11|5" minRot="-33" maxRot="30" />
		<right index="0>12" rotIndex="0>12|5" minRot="-30" maxRot="33" />
	</fenderRot>
	]]--
	
	self.frl = {};
	self.frl.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenderRot.left#index"));
	self.frl.idxRot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenderRot.left#rotIndex"));
	self.frl.minRot = math.rad( getXMLFloat(xmlFile, "vehicle.fenderRot.left#minRot") );
	self.frl.maxRot = math.rad( getXMLFloat(xmlFile, "vehicle.fenderRot.left#maxRot") );
	
	self.frr = {};
	self.frr.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenderRot.right#index"));
	self.frr.idxRot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenderRot.right#rotIndex"));
	self.frr.minRot = math.rad( getXMLFloat(xmlFile, "vehicle.fenderRot.right#minRot") );
	self.frr.maxRot = math.rad( getXMLFloat(xmlFile, "vehicle.fenderRot.right#maxRot") );
	
	--#
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;	
	
	--#
	--[[
	<driveDir>
		<forward index="0>5|1|0|0|1|7|0"/>
		<backward index="0>5|1|0|0|1|7|1"/>
	</driveDir>	
	]]--
	self.dd = {}
	self.dd.f = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.driveDir.forward#index"));
	self.dd.fa = false;
	self.dd.b = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.driveDir.backward#index"));
	self.dd.ba = false;
	setVisibility( self.dd.f, false );
	setVisibility( self.dd.b, false );
end;

function Fendt936:delete()

end

function Fendt936:readStream(streamId, connection)
end;

function Fendt936:writeStream(streamId, connection)
end;

function Fendt936:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt936:keyEvent(unicode, sym, modifier, isDown)
end;

function Fendt936:update(dt)

	--print("self.selectedImplement="..tostring(self.selectedImplement));
	--print("self="..tostring(self));
	--print("self.isSelected="..tostring(self.isSelected));
	
	--[[
	if (self.selectedImplement == nil) and self.mtReactivated == false then
		--for i,tool in pairs(self.movingTools) do
		--	tool.rotSpeed = tool.rotSpeedBackup;
		--	tool.transSpeed = tool.transSpeedBackup;
		--end;
		for i,j in pairs(self.mc[1]) do
			self.movingTools[j].rotSpeed = self.movingTools[j].rotSpeedBackup;
			self.movingTools[j].transSpeed = self.movingTools[j].transSpeedBackup;
		end;		
		self.mtReactivated = true;
	elseif not (self.selectedImplement == nil) and self.mtReactivated == true then
		self.mtReactivated = false;
	end;
	]]--

	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.RESET_MOVEABLE_SEAT_MC) then							-- 
				for i,j in pairs(self.mc[1]) do
					setTranslation(self.movingTools[j].node, unpack(self.movingTools[j].origPos));
					self.movingTools[j].curTrans = { unpack(self.movingTools[j].origPos) };
					Cylindered.setDirty(self, self.movingTools[j]);
				end;
			end;		
		end;
	end;	
	
	
	--##
	if self.frl.idx ~= nil and self.frl.idxRot ~= nil then
		local rx,ry,rz = getRotation(self.frl.idx);
		if ry > self.frl.maxRot then
			setRotation(self.frl.idxRot, 0, self.frl.maxRot - ry, 0 );
		else
			setRotation(self.frl.idxRot, 0, 0, 0 );
		end;
	end;
	if self.frr.idx ~= nil and self.frr.idxRot ~= nil then
		local rx,ry,rz = getRotation(self.frr.idx);
		if ry < self.frr.minRot then
			setRotation(self.frr.idxRot, 0, self.frr.minRot - ry, 0 );
		else
			setRotation(self.frr.idxRot, 0, 0, 0 );
		end;
	end;
	
	--#
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then			
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then 
						self.nextAction = false;
					end;
				end;
			end;		
		end;
	end;
	
	--#
	--print(tostring(self.movingDirection).." "..tostring(self.lastSpeed*3600));

	
	if self.movingDirection > 0 and self.lastSpeed*3600 > 3 and self.dd.fa == false then
		self.dd.fa = true;
		setVisibility(self.dd.f, true);
	elseif self.dd.fa == true and (self.lastSpeed*3600 < 3 or self.movingDirection < 0) then
		self.dd.fa = false;
		setVisibility(self.dd.f, false);	
	end;
	if self.movingDirection < 0 and self.lastSpeed*3600 > 3 and self.dd.ba == false then
		self.dd.ba = true;
		setVisibility(self.dd.b, true);
	elseif self.dd.ba == true and (self.lastSpeed*3600 < 3 or self.movingDirection > 0) then
		self.dd.ba = false;
		setVisibility(self.dd.b, false);	
	end;
	
end;

function Fendt936:updateTick(dt)
	if self:getIsActive() then	
		if self.doLowering then	
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];	
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;			
			if self.loweringDone then
				self.delay = self.delay - dt;				
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;
	end;
	
	if self.attacherJoints[1].jointIndex == 0 and self.backHydDown == false then
		local jointDesc = self.attacherJoints[1];
		local rx,ry,rz = getRotation(jointDesc.bottomArm.rotationNode);
		rx  = rx - dt/1000;
		if rx < -math.rad(12) then
			rx = -math.rad(12);
			self.backHydDown = true;
		end;
		setRotation(jointDesc.bottomArm.rotationNode, rx, ry, rz);
		for i=1, table.getn(self.movingTools) do
			local tool = self.movingTools[i];
			Cylindered.setDirty(self, tool);
		end;
	else
		self.backHydDown = false;	
	end;
	
end;

function Fendt936:onLeave()
end;

function Fendt936:draw()
	--g_currentMission:addHelpButtonText(g_i18n:getText("RESET_MOVEABLE_SEAT_MC"), InputBinding.RESET_MOVEABLE_SEAT_MC);
	if self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;	
end;


function Fendt936:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;		
	end;
end;

function Fendt936:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;	
	end;
	
end;