--
--	SwitchMouseControl
--
--	written by fruktor
--	visit: www.eifok-team.de
--
--
--	free of charge
--
--


SwitchMouseControl = {};

function SwitchMouseControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(MouseControlsVehicle, specializations);
end;

function SwitchMouseControl:load(xmlFile)

	--###
	self.setActiveMC = SpecializationUtil.callSpecializationsFunction("setActiveMC");

	self.isSelectable = true;

	
	local cnt = getXMLInt(xmlFile, "vehicle.switchMouseControl#count");	
	self.activeMC			= 1;
	self.activeMCcnt		= cnt;

	--#
	self.mc = {};
	self.mcNames = {};
	
	for i=1,cnt do 
		
		self.mc[i] = {};
		
		local name = getXMLString(xmlFile, string.format("vehicle.switchMouseControl.mc%d#name", i) );
		if name == nil then
			print("::ERROR::SwitchMouseCoontrol:: could not find enough entries");
			break;
		end;
		self.mcNames[i] = name;
		r = 1;
		while true do
			local idx = getXMLInt(xmlFile, string.format("vehicle.switchMouseControl.mc%d#index%d", i, r) );
			if idx == nil then break;
			else
				table.insert( self.mc[i], idx );
			end;
			r = r + 1;
		end;		
	end;

	
	
	--#
	for i,tool in pairs(self.movingTools) do
		tool.rotSpeedBackup = 0;
		tool.transSpeedBackUp = 0;
		if tool.rotSpeed ~= nil then
			tool.rotSpeedBackup = tool.rotSpeed;
			tool.rotSpeed = 0;
		end;
		if tool.transSpeed ~= nil then
			tool.transSpeedBackup = tool.transSpeed;
			tool.transSpeed = 0;
		end;
	end;	

	for i,j in pairs(self.mc[self.activeMC]) do
		if self.movingTools[j].rotSpeedBackup ~= nil then
			self.movingTools[j].rotSpeed = self.movingTools[j].rotSpeedBackup;
		end;
		if self.movingTools[j].transSpeedBackup ~= nil then
			self.movingTools[j].transSpeed = self.movingTools[j].transSpeedBackUp;
		end;
	end;
	
	
	--###
	for axis,entry in pairs(self.mouseControlsIcons) do	
		entry.backUpIcon = entry.iconFilename;
		entry.iconFilename = nil;
	end;


	--###
	
	g_mouseControlsHelp.active = false;
end;


function SwitchMouseControl:delete()
end;


function SwitchMouseControl:readStream(streamId, connection)
--[[print("function SwitchMouseControl:readStream(streamId, connection)");
print("self.activeMC="..tostring(self.activeMC));
	self.activeMC = streamReadInt32(streamId);
print("self.activeMC="..tostring(self.activeMC));	
	self.activeMC = math.max( 1, math.min( self.activeMCcnt, self.activeMC ) );
	for i,j in pairs(self.mc) do
		for k,l in pairs(j) do 
			if i == self.activeMC then
				self.movingTools[l].rotSpeed = self.movingTools[l].rotSpeedBackup;
				self.movingTools[l].transSpeed = self.movingTools[l].transSpeedBackup;
			else
				self.movingTools[l].rotSpeed = 0;
				self.movingTools[l].transSpeed = 0;
			end;	
		end;
	end;		
]]--
end;

function SwitchMouseControl:writeStream(streamId, connection)
--print("function SwitchMouseControl:writeStream(streamId, connection)");
--print("self.activeMC="..tostring(self.activeMC));
--	streamWriteInt32(streamId, self.activeMC);
end;
	
function SwitchMouseControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SwitchMouseControl:keyEvent(unicode, sym, modifier, isDown)
end;

function SwitchMouseControl:update(dt)
	g_mouseControlsHelp.active = false;
	if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		if InputBinding.hasEvent(InputBinding.SWITCHMC) then
			local tmp = self.activeMC + 1;
			if tmp > self.activeMCcnt then 
				tmp = 1;
			end;
			self:setActiveMC( tmp );
		end;	
	end;
end;

function SwitchMouseControl:updateTick(dt)
end;

function SwitchMouseControl:draw()
	if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		--print("self.activeMC="..tostring(self.activeMC).."   self.mcNames[self.activeMC]="..tostring(self.mcNames[self.activeMC]) );
		g_currentMission:addHelpButtonText( string.format( g_i18n:getText("SWITCHMC"), self.mcNames[self.activeMC]), InputBinding.SWITCHMC );
	end;
end;

function SwitchMouseControl:onDetach()
end;

function SwitchMouseControl:setActiveMC(idx, noEventSend)
	if noEventSend == nil or noEventSend == false then
		--SetActiveMCEvent.sendEvent(self, idx, noEventSend); -- no event necessary ?
	end;
	self.activeMC = idx;
	for i,j in pairs(self.mc) do
		for k,l in pairs(j) do 
			if i == idx then
				self.movingTools[l].rotSpeed = self.movingTools[l].rotSpeedBackup;
				self.movingTools[l].transSpeed = self.movingTools[l].transSpeedBackup;
			else
				self.movingTools[l].rotSpeed = 0;
				self.movingTools[l].transSpeed = 0;
			end;	
		end;
	end;	
end;


--
--
--
--
--
SetActiveMCEvent = {};
SetActiveMCEvent_mt = Class(SetActiveMCEvent, Event);

InitEventClass(SetActiveMCEvent, "SetActiveMCEvent");

function SetActiveMCEvent:emptyNew()
    local self = Event:new(SetActiveMCEvent_mt);
    self.className="SetActiveMCEvent";
    return self;
end;

function SetActiveMCEvent:new(object, state)
    local self = SetActiveMCEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetActiveMCEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetActiveMCEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.state);
end;

function SetActiveMCEvent:run(connection)
    self.object:setActiveMC(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetActiveMCEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetActiveMCEvent.sendEvent(vehicle, state, noEventSend)
    if state ~= vehicle.activeMC then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetActiveMCEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetActiveMCEvent:new(vehicle, state));
            end;
        end;
    end;
end;

