SetMotorBrakeForceEvent = {};
SetMotorBrakeForceEvent_mt = Class(SetMotorBrakeForceEvent, Event);

InitEventClass(SetMotorBrakeForceEvent, "SetMotorBrakeForceEvent");

function SetMotorBrakeForceEvent:emptyNew()
    local self = Event:new(SetMotorBrakeForceEvent_mt);
    self.className="SetMotorBrakeForceEvent";
    return self;
end;

function SetMotorBrakeForceEvent:new(vehicle, brakeForce)
    local self = SetMotorBrakeForceEvent:emptyNew()
    self.vehicle = vehicle;
	self.brakeForce = brakeForce;
    return self;
end;

function SetMotorBrakeForceEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.brakeForce = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetMotorBrakeForceEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.brakeForce);
end;

function SetMotorBrakeForceEvent:run(connection)
	self.vehicle:setMotorBrakeForce(self.brakeForce);
end;
