-- Folding Front Linkage event-class
SetFrontLinkageFoldedEvent = {};
SetFrontLinkageFoldedEvent_mt = Class(SetFrontLinkageFoldedEvent, Event);

InitEventClass(SetFrontLinkageFoldedEvent, "SetFrontLinkageFoldedEvent");

function SetFrontLinkageFoldedEvent:emptyNew()
    local self = Event:new(SetFrontLinkageFoldedEvent_mt);
    self.className="SetFrontLinkageFoldedEvent";
    return self;
end;

function SetFrontLinkageFoldedEvent:new(vehicle, isFrontLinkageFolded)
    local self = SetFrontLinkageFoldedEvent:emptyNew()
    self.vehicle = vehicle;
	self.isFrontLinkageFolded = isFrontLinkageFolded;
    return self;
end;

function SetFrontLinkageFoldedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isFrontLinkageFolded = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetFrontLinkageFoldedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isFrontLinkageFolded);
end;

function SetFrontLinkageFoldedEvent:run(connection)
	self.vehicle:foldFrontLinkage(self.isFrontLinkageFolded, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetFrontLinkageFoldedEvent:new(self.vehicle, self.isFrontLinkageFolded), nil, connection, self.vehicle);
    end;
end;

function SetFrontLinkageFoldedEvent.sendEvent(vehicle, isFrontLinkageFolded, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFrontLinkageFoldedEvent:new(vehicle, isFrontLinkageFolded), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFrontLinkageFoldedEvent:new(vehicle, isFrontLinkageFolded));
		end;
	end;
end;
