-- Power Command change shuttle to neutral event-class
ChangeHandBrakeStateEvent = {};
ChangeHandBrakeStateEvent_mt = Class(ChangeHandBrakeStateEvent, Event);

InitEventClass(ChangeHandBrakeStateEvent, "ChangeHandBrakeStateEvent");

function ChangeHandBrakeStateEvent:emptyNew()
    local self = Event:new(ChangeHandBrakeStateEvent_mt);
    self.className="ChangeHandBrakeStateEvent";
    return self;
end;

function ChangeHandBrakeStateEvent:new(vehicle, currentHandbrakeState)
    local self = ChangeHandBrakeStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentHandbrakeState = currentHandbrakeState;
    return self;
end;

function ChangeHandBrakeStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.currentHandbrakeState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeHandBrakeStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.currentHandbrakeState);
end;

function ChangeHandBrakeStateEvent:run(connection)
	self.vehicle:changeHandbrakeState(self.currentHandbrakeState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ChangeHandBrakeStateEvent:new(self.vehicle, self.currentHandbrakeState), nil, connection, self.vehicle);
    end;
end;

function ChangeHandBrakeStateEvent.sendEvent(vehicle, currentHandbrakeState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeHandBrakeStateEvent:new(vehicle, currentHandbrakeState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeHandBrakeStateEvent:new(vehicle, currentHandbrakeState));
		end;
	end;
end;
