-- Change 4wd state event-class
Change4wdStateEvent = {};
Change4wdStateEvent_mt = Class(Change4wdStateEvent, Event);

InitEventClass(Change4wdStateEvent, "Change4wdStateEvent");

function Change4wdStateEvent:emptyNew()
    local self = Event:new(Change4wdStateEvent_mt);
    self.className="Change4wdStateEvent";
    return self;
end;

function Change4wdStateEvent:new(vehicle, current4wdState)
    local self = Change4wdStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.current4wdState = current4wdState;
    return self;
end;

function Change4wdStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.current4wdState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function Change4wdStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.current4wdState);
end;

function Change4wdStateEvent:run(connection)
	self.vehicle:change4wdState(self.current4wdState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(Change4wdStateEvent:new(self.vehicle, self.current4wdState), nil, connection, self.vehicle);
    end;
end;

function Change4wdStateEvent.sendEvent(vehicle, current4wdState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Change4wdStateEvent:new(vehicle, current4wdState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Change4wdStateEvent:new(vehicle, current4wdState));
		end;
	end;
end;
