--
-- aiNightlight
--
-- @author  Jack
-- @date  01/05/09
--
-- Copyright (C) Jack

aiNightlight = {};

function aiNightlight.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function aiNightlight:load(xmlFile)
end;

function aiNightlight:keyEvent(unicode, sym, modifier, isDown)
end;

function aiNightlight:update(dt)

	if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 

end;

function aiNightlight:draw()
end;

function aiNightlight:onEnter()
end;

function aiNightlight:onLeave()
end;

function aiNightlight:delete()
end;

function aiNightlight:mouseEvent(posX, posY, isDown, isUp, button)
end;






