-- digitalKmhDisplay
-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- released with and for Fendt 309 LSA
-- date 30.04.2014


digitalKmhDisplay = {};

function digitalKmhDisplay.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function digitalKmhDisplay:load(xmlFile)
	self.shutOff = digitalKmhDisplay.shutOff;
	self.digits = {};
	self.digits.pointOnes = {};
	self.digits.ones = {};
	self.digits.tens = {}
	
	local pointOnesIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitalKmhDisplay#pointOnesIndex"));
	local onesIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitalKmhDisplay#onesIndex"));
	local tensIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitalKmhDisplay#tensIndex"));
	self.pointIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitalKmhDisplay#pointIndex")); 
	if pointOnesIndex ~= nil then
		for i=0, 9 do
			local child = getChildAt(pointOnesIndex, i);
			self.digits.pointOnes[i] = child;
		end;
	end;
	if onesIndex ~= nil then
		for i=0, 9 do
			local child = getChildAt(onesIndex, i);
			self.digits.ones[i] = child;
		end;
	end;
	if tensIndex ~= nil then
		for i=0, 9 do
			local child = getChildAt(tensIndex, i);
			self.digits.tens[i] = child;
		end;
	end;	
	self.iskmhDisplayActive = false;
end;

function digitalKmhDisplay:delete()
end;
function digitalKmhDisplay:mouseEvent(posX, posY, isDown, isUp, button)
end;
function digitalKmhDisplay:keyEvent(unicode, sym, modifier, isDown)
end;
function digitalKmhDisplay:update(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			if not self.iskmhDisplayActive then
				setVisibility(self.pointIndex, true)
				self.iskmhDisplayActive = true;
			end;
			local kmh = math.min(math.max(0, self.lastSpeed*self.speedDisplayScale*3600), 99);
			local tens = math.floor(kmh / 10);
			local ones = math.floor(kmh - (tens*10));
			local pointOnes = math.floor(kmh * 10 - ((tens*10+ones)*10));
			for i=0, 9 do
				setVisibility(self.digits.tens[i], i==tens);
				setVisibility(self.digits.ones[i], i==ones);
				setVisibility(self.digits.pointOnes[i], i==pointOnes);
			end;
		else
			self:shutOff()
		end;
	end;	
end;
function digitalKmhDisplay:shutOff()
	setVisibility(self.pointIndex, true)
	self.iskmhDisplayActive = false;
	for i=0, 9 do
		setVisibility(self.digits.tens[i], false);
		setVisibility(self.digits.ones[i], false);
		setVisibility(self.digits.pointOnes[i], false);
	end;	
end;
function digitalKmhDisplay:onLeave()
	self:shutOff();
end;
function digitalKmhDisplay:updateTick(dt)
end;

function digitalKmhDisplay:draw()
end;