--
-- Fendt Forest Support Script
--
-- (C) Kirezagar
-- MADE-IN-SLOVENIA
--
-- www.LS-SLO.si
--

FendtForest = {}

function FendtForest.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function FendtForest:load(xmlFile)


    local transLeftJackNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.transLeftJack#index"));
        if transLeftJackNode ~= nil then
        self.transLeftJack = {};
        self.transLeftJack.node = transLeftJackNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transLeftJack#minTrans"));
        self.transLeftJack.minTrans = {};
        self.transLeftJack.minTrans[1] = Utils.getNoNil(x, 0);
        self.transLeftJack.minTrans[2] = Utils.getNoNil(y, 0);
        self.transLeftJack.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transLeftJack#maxTrans"));
        self.transLeftJack.maxTrans = {};
        self.transLeftJack.maxTrans[1] = Utils.getNoNil(x, 0);
        self.transLeftJack.maxTrans[2] = Utils.getNoNil(y, 0);
        self.transLeftJack.maxTrans[3] = Utils.getNoNil(z, 0);

        self.transLeftJack.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.transLeftJack#transTime"), 2)*1000;
        self.transLeftJack.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.transLeftJack#touchTransLimit"), 10);
    end;

    local transRightJackNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.transRightJack#index"));
        if transRightJackNode ~= nil then
        self.transRightJack = {};
        self.transRightJack.node = transRightJackNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transRightJack#minTrans"));
        self.transRightJack.minTrans = {};
        self.transRightJack.minTrans[1] = Utils.getNoNil(x, 0);
        self.transRightJack.minTrans[2] = Utils.getNoNil(y, 0);
        self.transRightJack.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transRightJack#maxTrans"));
        self.transRightJack.maxTrans = {};
        self.transRightJack.maxTrans[1] = Utils.getNoNil(x, 0);
        self.transRightJack.maxTrans[2] = Utils.getNoNil(y, 0);
        self.transRightJack.maxTrans[3] = Utils.getNoNil(z, 0);

        self.transRightJack.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.transRightJack#transTime"), 2)*1000;
        self.transRightJack.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.transRightJack#touchTransLimit"), 10);
    end;

    self.engineUnderLoadEvent = SpecializationUtil.callSpecializationsFunction("engineUnderLoadEvent");
    self.setEngineLoadState = SpecializationUtil.callSpecializationsFunction("setEngineLoadState");
    self.engineUnderLoadEffect = {};
    self.engineUnderLoadEffect.engineIsUnderLoad = false;
    self.engineUnderLoadEffect.motorSoundPitchOffsetNormal = self.motorSoundPitchOffset;
    self.engineUnderLoadEffect.exhaustParticleSystems = {};

    self.showHUDInfo = false;

end;

function FendtForest:delete()
end;

function FendtForest:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FendtForest:keyEvent(unicode, sym, modifier, isDown)
end;

function FendtForest:update(dt)

        -- Log support
	local leftJackLower = InputBinding.isPressed(InputBinding.FForest_LEFT_JACK_LOWER);
       	local leftJackRaise = InputBinding.isPressed(InputBinding.FForest_LEFT_JACK_RAISE);
        if self.transLeftJack ~= nil and (leftJackLower or leftJackRaise) then
		local x, y, z = getTranslation(self.transLeftJack.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.transLeftJack.maxTrans, self.transLeftJack.minTrans, 3, self.transLeftJack.transTime, dt, not leftJackLower);
		setTranslation(self.transLeftJack.node, unpack(newTrans));
		setJointFrame(self.componentJoints[1].jointIndex,0,self.componentJoints[1].jointNode);

                self:engineUnderLoadEvent(self.engineUnderLoadEffect.enabledJacks);
	end;

	local rightJackLower = InputBinding.isPressed(InputBinding.FForest_RIGHT_JACK_LOWER);
       	local rightJackRaise = InputBinding.isPressed(InputBinding.FForest_RIGHT_JACK_RAISE);
        if self.transRightJack ~= nil and (rightJackLower or rightJackRaise) then
		local x, y, z = getTranslation(self.transRightJack.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.transRightJack.maxTrans, self.transRightJack.minTrans, 3, self.transRightJack.transTime, dt, not rightJackLower);
		setTranslation(self.transRightJack.node, unpack(newTrans));
		setJointFrame(self.componentJoints[2].jointIndex,0,self.componentJoints[2].jointNode);

                self:engineUnderLoadEvent(self.engineUnderLoadEffect.enabledJacks);
	end;
	
	end;


function FendtForest:draw()
         
         if self.isEntered and self.showHUDInfo then


            if self.isMotorStarted then
               
               g_currentMission:addExtraPrintText(string.format("Back Support: %s,%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.FForest_LEFT_JACK_LOWER), InputBinding.getKeyNamesOfDigitalAction(InputBinding.FForest_LEFT_JACK_RAISE)));
               g_currentMission:addExtraPrintText(string.format("Front Support: %s,%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.FForest_RIGHT_JACK_LOWER), InputBinding.getKeyNamesOfDigitalAction(InputBinding.FForest_RIGHT_JACK_RAISE)));
            end;
  	end;
end;