--
--	author: fruktor
-- 	date: 	13.12.2013
--
--


SetCuttingPSEvent = {};
SetCuttingPSEvent_mt = Class(SetCuttingPSEvent, Event);
InitEventClass(SetCuttingPSEvent, "SetCuttingPSEvent");
function SetCuttingPSEvent:emptyNew()
    local self = Event:new(SetCuttingPSEvent_mt);
    self.className="SetCuttingPSEvent";
    return self;
end;

function SetCuttingPSEvent:new(object, state)
    local self = SetCuttingPSEvent:emptyNew(); 
    self.object = object; 
	self.state = state;
    return self;
end;

function SetCuttingPSEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.state);
end;

function SetCuttingPSEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetCuttingPSEvent:run(connection)
	self.object:setCuttingPS(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetCuttingPSEvent:new(self.object, self.state), nil, connection, self.object);
	end; 
end;

function SetCuttingPSEvent.sendEvent(object, state, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(SetCuttingPSEvent:new(object, state), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(SetCuttingPSEvent:new(object, state)); 
		end;
	end;
end;

