--
--
--
--
--

Cablight = {};

function Cablight.prerequisitesPresent(specializations)
    return true;
end;

function Cablight:load(xmlFile)
	self.setCablight = SpecializationUtil.callSpecializationsFunction("setCablight");
	self.cl = {};
	self.cl.rl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cablight#realLight"));
	self.cl.be = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cablight#beam"));
	self.cl.co = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cablight#corona"));
	self.cl.turnOn = false;
	self.cl.isOn = false;
	self.cl.active = false;
	setVisibility( self.cl.rl, false );
	setVisibility( self.cl.be, false );
	setVisibility( self.cl.co, false );
end;

function Cablight:delete()
end;

function Cablight:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setCablight(state, true);
end;

function Cablight:writeStream(streamId, connection)
	streamWriteBool(streamId, self.cl.turnOn);
end;

function Cablight:readUpdateStream(streamId, timestamp, connection)
end;

function Cablight:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Cablight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Cablight:keyEvent(unicode, sym, modifier, isDown)
end;

function Cablight:update(dt)
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.SWITHCABLIGHT) then
				self:setCablight(not self.cl.turnOn);
			end;
		end;
	end;
	
	local realLightsActive = false;
	--if self.cl.turnOn then 
		realLightsActive = self:getIsActiveForLights();
	--end;
	
	if (self.cl.turnOn == true and self.cl.isOn == false) or (self.cl.active ~= realLightsActive) then
		if self.cl.rl ~= nil then
			if realLightsActive then
				setVisibility( self.cl.rl, true );
				if self.cl.be ~= nil then
					setVisibility( self.cl.be, false );
				end;
			else
				setVisibility( self.cl.rl, false );
				if self.cl.be ~= nil then
					setVisibility( self.cl.be, true );
				end;
			end
		end;
		if self.cl.co ~= nil then
			setVisibility( self.cl.co, true );			
		end;
		self.cl.active = realLightsActive;
		self.cl.isOn = true;
	elseif (self.cl.turnOn == false and self.cl.isOn == true) then
		if self.cl.rl ~= nil then
			setVisibility( self.cl.rl, false );
		end;
		if self.cl.be ~= nil then
			setVisibility( self.cl.be, false );
		end;
		if self.cl.co ~= nil then
			setVisibility( self.cl.co, false );		
		end;
		self.cl.isOn = false;
	end;
end;

function Cablight:updateTick(dt)

end;

function Cablight:draw()
	if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		g_currentMission:addHelpButtonText( g_i18n:getText("SWITHCABLIGHT"), InputBinding.SWITHCABLIGHT );
	end;
end;

function Cablight:onLeave()

end;

function Cablight:onEnter()

end;

function Cablight:setCablight(state, noEventSend)
	SetCablightEvent.sendEvent(self, state, noEventSend);
	self.cl.turnOn = state;
end;
	
	
	
--
--
--
--
--
SetCablightEvent = {};
SetCablightEvent_mt = Class(SetCablightEvent, Event);

InitEventClass(SetCablightEvent, "SetCablightEvent");

function SetCablightEvent:emptyNew()
    local self = Event:new(SetCablightEvent_mt);
    self.className="SetCablightEvent";
    return self;
end;

function SetCablightEvent:new(object, state)
    local self = SetCablightEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetCablightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetCablightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetCablightEvent:run(connection)
    self.object:setCablight(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetCablightEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetCablightEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCablightEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCablightEvent:new(vehicle, state));
		end;
	end;
end;

