SetRealLight_BrakeIsPressedEvent = {};
SetRealLight_BrakeIsPressedEvent_mt = Class(SetRealLight_BrakeIsPressedEvent, Event);

InitEventClass(SetRealLight_BrakeIsPressedEvent, "SetRealLight_BrakeIsPressedEvent");

function SetRealLight_BrakeIsPressedEvent:emptyNew()
    local self = Event:new(SetRealLight_BrakeIsPressedEvent_mt);
    self.className="SetRealLight_BrakeIsPressedEvent";
    return self;
end;
		 
function SetRealLight_BrakeIsPressedEvent:new(vehicle, state)
    local self = SetRealLight_BrakeIsPressedEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetRealLight_BrakeIsPressedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRealLight_BrakeIsPressedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetRealLight_BrakeIsPressedEvent:run(connection)
	self.vehicle:setBrakeIsPressed(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRealLight_BrakeIsPressedEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetRealLight_BrakeIsPressedEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRealLight_BrakeIsPressedEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRealLight_BrakeIsPressedEvent:new(vehicle, state));
		end;
	end;
end;