SetRealLight_BlinkerWEvent = {};
SetRealLight_BlinkerWEvent_mt = Class(SetRealLight_BlinkerWEvent, Event);

InitEventClass(SetRealLight_BlinkerWEvent, "SetRealLight_BlinkerWEvent");

function SetRealLight_BlinkerWEvent:emptyNew()
    local self = Event:new(SetRealLight_BlinkerWEvent_mt);
    self.className="SetRealLight_BlinkerWEvent";
    return self;
end;

function SetRealLight_BlinkerWEvent:new(vehicle, state)
    local self = SetRealLight_BlinkerWEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetRealLight_BlinkerWEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRealLight_BlinkerWEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetRealLight_BlinkerWEvent:run(connection)
	self.vehicle:setBlinkerWState(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRealLight_BlinkerWEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetRealLight_BlinkerWEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRealLight_BlinkerWEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRealLight_BlinkerWEvent:new(vehicle, state));
		end;
	end;
end;