SetRealLight_BlinkerLEvent = {};
SetRealLight_BlinkerLEvent_mt = Class(SetRealLight_BlinkerLEvent, Event);

InitEventClass(SetRealLight_BlinkerLEvent, "SetRealLight_BlinkerLEvent");

function SetRealLight_BlinkerLEvent:emptyNew()
    local self = Event:new(SetRealLight_BlinkerLEvent_mt);
    self.className="SetRealLight_BlinkerLEvent";
    return self;
end;

function SetRealLight_BlinkerLEvent:new(vehicle, state)
    local self = SetRealLight_BlinkerLEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetRealLight_BlinkerLEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRealLight_BlinkerLEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetRealLight_BlinkerLEvent:run(connection)
	self.vehicle:setBlinkerLState(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRealLight_BlinkerLEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetRealLight_BlinkerLEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRealLight_BlinkerLEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRealLight_BlinkerLEvent:new(vehicle, state));
		end;
	end;
end;