--
-- add specialization to all mods.
--
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2012-11-11
-- @history:    v1.0 - inital implementation
--

addSpecialization = {};
addSpecialization.isLoaded = true;
addSpecialization.g_currentModDirectory = g_currentModDirectory;

if SpecializationUtil.specializations["manualIgnition"] == nil then
	SpecializationUtil.registerSpecialization("manualIgnition", "manualIgnition", g_currentModDirectory .. "manualIgnition.lua")
	addSpecialization.isLoaded = false;
-- else
	-- print("  manualIgnition have been loaded already!");
end;

addModEventListener(addSpecialization);

function addSpecialization:loadMap(name)	
    if not addSpecialization.isLoaded then
	
		addSpecialization:add();
		
		local x = 0.01;
		local y = -0.015;
		local width = 0.0371111;
		local height = 0.256;
		
		g_currentMission.ignitionOverlay = {};
		g_currentMission.ignitionOverlay[1] = Overlay:new("ignitionOverlay1", Utils.getFilename("bg.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		g_currentMission.ignitionOverlay[2] = Overlay:new("ignitionOverlay2", Utils.getFilename("step1.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		g_currentMission.ignitionOverlay[3] = Overlay:new("ignitionOverlay3", Utils.getFilename("step2.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		g_currentMission.ignitionOverlay[4] = Overlay:new("ignitionOverlay4", Utils.getFilename("step3.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		
        addSpecialization.isLoaded = true;
    end;
end;

function addSpecialization:deleteMap()
    addSpecialization.isLoaded = false;
	
	for _, hud in ipairs(g_currentMission.ignitionOverlay) do
		hud:delete();
	end;
	g_currentMission.ignitionOverlay = nil;
end;

function addSpecialization:mouseEvent(posX, posY, isDown, isUp, button)
end;

function addSpecialization:keyEvent(unicode, sym, modifier, isDown)
end;

function addSpecialization:update(dt)
end;

function addSpecialization:draw()
end;

function addSpecialization:add()
	local searchTable = {
		"manualIgnition",
		"ignition",
		"ManualIgnition",
		"manualignition",
		"Ignition"
		};
	
	for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
		local modName = string.match(k, "([^.]+)");
		
		local addSpecialization = true;
		for _, search in pairs(searchTable) do
			if SpecializationUtil.specializations[modName .. "." .. search] ~= nil then
				addSpecialization = false;
				break;
			end;
		end;
		
		if SpecializationUtil.hasSpecialization(manualIgnition, v.specializations) then
			addSpecialization = false;
			break;
		end;
		
		local correctLocation = false;
		for i = 1, table.maxn(v.specializations) do
			local vs = v.specializations[i];
			if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
				correctLocation = true;
				break;
			end;
		end;
		
		if addSpecialization and correctLocation then
			table.insert(v.specializations, SpecializationUtil.getSpecialization("manualIgnition"));
			-- print("  manualIgnition was inserted on " .. k);
		elseif correctLocation and not addSpecialization then
			print("  Failed to inserting manualIgnition on " .. k);
		end;
	end;
	
	-- make l10n global 
	local i = 1;
	while true do
		local txt = string.format("MANUAL_IGNITION_%d", i);
		if not g_i18n:hasText(txt) then
			break;
		end;
		g_i18n.globalI18N.texts[txt] = g_i18n:getText(txt);
		
		i = i + 1;
	end;
end;