SpecializationUtil.registerSpecialization("realLights", "RealLights", g_currentModDirectory.."RealLights.lua")


RealLights_Register = {};

function RealLights_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		print("--- loading RealLights - specialization for RealLights by fruktor (www.eifok-team.de)");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil then --and vs == SpecializationUtil.getSpecialization("steerable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.BEL31", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization BEL31 is present! ");
								break;
							end;							
							if rawget(SpecializationUtil.specializations, string.format("%s.BEL3", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization BEL3 is present! ");
								break;
							end;
							if rawget(SpecializationUtil.specializations, string.format("%s.beleuchtung31", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization beleuchtung31 is present! ");
								break;
							end;							
							if rawget(SpecializationUtil.specializations, string.format("%s.beleuchtung3", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization beleuchtung3 is present! ");
								break;
							end;	
							if rawget(SpecializationUtil.specializations, string.format("%s.extralight", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization extralight is present! ");
								break;
							end;		
							if rawget(SpecializationUtil.specializations, string.format("%s.beleuchtung", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization beleuchtung is present! ");
								break;
							end;		
							if rawget(SpecializationUtil.specializations, string.format("%s.additionalLights", _name)) ~= nil then
								allowInsertion = false;
								print("[INFO::RealLights] deactivated for "..tostring(v.name).." ,because specialization additionalLights is present! ");
								break;
							end;								
						end;
						
					end;
				end;
				
				--v.rlBL = InputBindings.REALLIGHTS_BLINKL

				if allowInsertion then
					--print("---> adding RealLights to:"..tostring(v.name));
					table.insert(v.specializations, SpecializationUtil.getSpecialization("realLights"));
				end;
				
			end;	
		end;
	end;
end;

function RealLights_Register:deleteMap()
  
end;

function RealLights_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function RealLights_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function RealLights_Register:update(dt)
	
end;

function RealLights_Register:draw()
  
end;

addModEventListener(RealLights_Register);