--
-- AdjustedSteering
-- Specialization for AdjustedSteering
--
-- written by:	fruktor, www.eifok-team.de
-- inspired by: modelleicher and bullet
--

AdjustedSteering = {};

function AdjustedSteering.prerequisitesPresent(specializations)
    return true; --SpecializationUtil.hasSpecialization(Cylindered, specializations); 
end;

function AdjustedSteering:load(xmlFile)
	
	-- <adjustedSteering innerRot="30" outerRot="25" wheelCnt="2" wheelIds="1 2"/>
	
	--###
	self.as = {};
	
	self.as.radI = math.rad( Utils.getNoNil( getXMLFloat( xmlFile, "vehicle.adjustedSteering#innerRot" ), 0 ) );
	self.as.radO = math.rad( Utils.getNoNil( getXMLFloat( xmlFile, "vehicle.adjustedSteering#outerRot" ), 0 ) );
	
	local wc = getXMLInt(xmlFile, "vehicle.adjustedSteering#wheelCnt" );
	local ids;
	if wc ~= nil then
		ids = Utils.getVectorNFromString( getXMLString(xmlFile, "vehicle.adjustedSteering#wheelIds" ) );
	else
		print("[ERROR - AdjustedSteering] No wheel IDs given");	
	end;
	if ids == nil then
		print("[ERROR - AdjustedSteering] wheel IDs could not be loaded!");	
	end;
	
	self.as.ids = ids;
	
end;

function AdjustedSteering:delete()
end;

function AdjustedSteering:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AdjustedSteering:keyEvent(unicode, sym, modifier, isDown)
end;

function AdjustedSteering:update(dt)
	--print("self.rotatedTime = "..tostring(self.rotatedTime));
	
	--### 
	-- turn left 
	if self.rotatedTime > 0 then
	
		--self.wheels[ self.as.ids[1] ].rotMin = -self.as.radI * (self.rotatedTime / self.maxRotTime);
		--self.wheels[ self.as.ids[2] ].rotMin = -self.as.radO * (self.rotatedTime / self.maxRotTime);
	
		self.wheels[ self.as.ids[1] ].rotSpeed = -self.as.radI / self.minRotTime;
		self.wheels[ self.as.ids[2] ].rotSpeed = -self.as.radO / self.minRotTime;

	elseif self.rotatedTime < 0 then -- turn right 

		--self.wheels[ self.as.ids[1] ].rotMax = self.as.radO * (self.rotatedTime / self.maxRotTime);
		--self.wheels[ self.as.ids[2] ].rotMax = self.as.radI * (self.rotatedTime / self.maxRotTime);
	
		self.wheels[ self.as.ids[1] ].rotSpeed = self.as.radO / self.maxRotTime;
		self.wheels[ self.as.ids[2] ].rotSpeed = self.as.radI / self.maxRotTime;
	
	else
		
	
	end;

	
end;

function AdjustedSteering:updateTick(dt)

end;

function AdjustedSteering:draw()
end;
