--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 4096, 4096);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 4096, 4096);

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 - 230, 0 + 439.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 - 144.65, 0 - 352.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 + 513.75, 0 + 202, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 + 723.9, 0 + 608.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 - 162, 0 - 679.51, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 0 - 130, 0 - 383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 + 89.6, 0 - 417.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 - 603.4, 0 - 834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 - 94, 0 + 20.1, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 - 560, 0 - 7.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 - 172.25, 0 - 678.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 + 43.5, 0 - 128.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 + 312, 0 - 30, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 0 + 888.8 , 0 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 0 + 753.5 , 0 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 0 + 640.4 , 0 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 0 + 692.7 , 0 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 0 - 350, 0 - 80, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 0 - 285, 0 + 15, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 0 - 12, 0 - 93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;