--
-- FahrGabelheuwender
-- Desc
--
-- @author  Geri-G
-- @date  19/05/09
--
-- Copyright (C) Geri-G.

FahrGabelheuwender = {};

 
function FahrGabelheuwender.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;
 

function FahrGabelheuwender:load(xmlFile)
	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
  	self.charId = {};
	self.clipIndex = {};
	self.Go = {}; 
	self.Done = {};
	self.CheckDone = {};
	self.collisionArm = {}; 
	self.collisionArm2 = {}; 
	self.moveColli = {}; 
	self.moveColli2 = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
    self.animParts = {}
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		self.moveColli2[nameR] = getXMLString(xmlFile, partname.."#moveColli2");		
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR, self.collisionArm[nameR]);
		end; 
		if self.moveColli2[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collision2"));
			Collision.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collsionAttacher2"));
			Collision.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.. "#armAttacher2"));
			Collision.index = 0;
			self.collisionArm2[nameR] = Collision;
			self:connectCollisions(nameR, self.collisionArm2[nameR]);
		end; 
	end; 
	self.AnimationspeedToLastSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.AnimationspeedToLastSpeed#Umrechnungszahl"), 800);

end;

function FahrGabelheuwender:delete()

end;

function FahrGabelheuwender:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FahrGabelheuwender:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_m then
		self.Go.workSource = not self.Go.workSource; 

	end;
end;

function FahrGabelheuwender:update(dt)
	if self.attacherVehicle ~= nil then 
		--renderText(0.2, 0.3, 0.03,  string.format("%s","lastSpeed *1000: "..self.attacherVehicle.lastSpeed*1000));
		--renderText(0.2, 0.2, 0.03,  string.format("%s","lastSpeed: "..self.attacherVehicle.lastSpeed));
		--renderText(0.2, 0.25, 0.03,  string.format("%s","lastSpeedReal: "..self.attacherVehicle.lastSpeedReal));
		--print(self.attacherVehicle.lastSpeedReal);
		--print(self.attacherVehicle.lastSpeed);
		--print(self.attacherVehicle.movingDirection);
		if self:getIsActive() then
			
			if self.isTurnedOn and self.AnimationspeedToLastSpeed ~=nil then

				local trieb = self.attacherVehicle.lastSpeed*self.AnimationspeedToLastSpeed;
				self.Go.workSource = true;
				if self.attacherVehicle.movingDirection == 1  then
					trieb = 1 * trieb;
				elseif self.attacherVehicle.movingDirection == -1  then
					trieb = 0; 
				elseif self.attacherVehicle.movingDirection == 0 and trieb <= 0.5  then
					self:anim("workSource",true, 0, true);
				end;
				self:anim("workSource",true, trieb, true); 
				--renderText(0.2, 0.2, 0.03,  string.format("%s","trieb: "..trieb));
			else
				self:anim("workSource",true, 0, true);
				self.Go.workSource = false;
			end;
		end; 
	end;
	if self.Go.fus ~= nil and self.Done.fus ~= false then
		self:anim("fus", false, 1, false); 
	end; 
end; 

function FahrGabelheuwender:anim(varName, loopCheck, speed, loop)

	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.moveColli2[varName] ~= nil then
		local Collision = self.collisionArm2[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if loop == false then	
		if self.Go[varName] == true and self.Done[varName] ~= false then
			local charId = getAnimCharacterSet(self.charId[varName]);
			local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, speed);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
				disableAnimTrack(charId, 0);	
				self.Done[varName] = false;	
				self.CheckDone[varName] = true;	     
			end; 
		elseif self.Go[varName] == false and self.Done[varName] ~= false then
			local charId = getAnimCharacterSet(self.charId[varName]);
			local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
			if loopCheck == true then
				disableAnimTrack(charId, 0);
				self.Done[varName] = false;	
			end; 	
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, -speed);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) <= 0 then
				disableAnimTrack(charId, 0);
				self.Done[varName] = false;	
				self.CheckDone[varName] = false;
			end;
		end;
	end;
	if loop == true then
		if self.Go[varName] == true then
			local charId = getAnimCharacterSet(self.charId[varName]);
			local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, speed);
			enableAnimTrack(charId, 0); 
		elseif self.Go[varName] == false then
			local charId = getAnimCharacterSet(self.charId[varName]);
			disableAnimTrack(charId, 0);
		end;	
	end;

end; 
function FahrGabelheuwender:draw()
end;

function FahrGabelheuwender:onDeactivate()
	self:anim("workSource",true, 0, true);
	self.Go.workSource = false;
end;
function FahrGabelheuwender:onAttach()
	self.Go.fus = not self.Go.fus; 
	self.Done.fus = true; 
end; 	


function FahrGabelheuwender:onDetach()
	self.Go.fus = not self.Go.fus; 
	self.Done.fus = true; 
end;