﻿--
--FruitNewPreparer = {};
--to add more then one fruitType in fruitPreparerVerhicles
--
--@Author:	Bluebaby210 www.mod-portal.com
--
--@Version: v1.0
--
--@date:	19.05.2013
--
--
--Versions:	v1.0 initial version
--
--free for noncommerical usage
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission


FruitNewPreparer = {};
 
function FruitNewPreparer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FruitPreparer, specializations);
end;
 
function FruitNewPreparer:load(xmlFile)

	self.fruitSwitched = SpecializationUtil.callSpecializationsFunction("fruitSwitched");

	self.newFruitPreparerFruitType = {};
	self.numberFillableFillTypeIndexToDesc = {};
	self.fruitOverlays = {};
	self.newFruitNumbers = 0;
	self.switchNumber = 1;
	self.allowedSwitch = true;
	self.hudTimer = 0;
	self.startTimer = false;
	self.renderHudFruit = false;
	
		local newFruitTypes = getXMLString(xmlFile, "vehicle.newFruitPreparer.types#fruitTypes");
		if newFruitTypes ~= nil then
			local newTypes = Utils.splitString(" ", newFruitTypes);
			for k,v in pairs(newTypes) do
				local newFillType = Fillable.fillTypeNameToInt[v];
				table.insert(self.newFruitPreparerFruitType, v);
				if Fillable.fillTypeIndexToDesc[newFillType] ~= nil then
					table.insert(self.numberFillableFillTypeIndexToDesc, newFillType);
					local overlay = createImageOverlay(Fillable.fillTypeIndexToDesc[newFillType].hudOverlayFilename);
					table.insert(self.fruitOverlays, k, overlay);
				end;
				if Fillable.fillTypeIndexToDesc[newFillType] == nil then
					table.insert(self.numberFillableFillTypeIndexToDesc, v);
				end;
				self.newFruitNumbers = self.newFruitNumbers + 1;
			end;
		end;


		local newAggregate = Utils.getNoNil(getXMLString(xmlFile, "vehicle.newFruitPreparer.aggregate#index"), nil);
		if newAggregate ~= nil then
			self.aggregatesNew = {};
			local newAggregateTypes = Utils.splitString(" ", newAggregate);
			for k,v in pairs(newAggregateTypes) do
			self.aggregatesNew[k] = Utils.indexToObject(self.components, v);
			setVisibility(self.aggregatesNew[k], false);
			end;
		end;

		if self.aggregatesNew ~= nil then
			if table.getn(self.newFruitPreparerFruitType) ~= table.getn(self.aggregatesNew) then
				if table.getn(self.aggregatesNew) >= 1 then
					setVisibility(self.aggregatesNew[1], true);
					self.aggregatesNew = nil;
				end;
			else
				setVisibility(self.aggregatesNew[self.switchNumber], true);
			end;
		end;
			
		
	self.fruitPreparerFruitType = self.numberFillableFillTypeIndexToDesc[self.switchNumber];

		
	if self.grainTankCapacity ~= nil then
		self.grainTankVehicle = true;
	else
		self.grainTankVehicle = false;
	end;
	
	if self.newFruitNumbers == 1 then
		self.allowedSwitch = false;
		self.grainTankVehicle = false;
	end;
end;
 
function FruitNewPreparer:delete()
end;
 
function FruitNewPreparer:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function FruitNewPreparer:keyEvent(unicode, sym, modifier, isDown)
end;
 
function FruitNewPreparer:update(dt)
	if self:getIsActive() then
		if self.allowedSwitch then
			if InputBinding.hasEvent(InputBinding.FruitSwitchHigh) then
				self:fruitSwitched(true, self.switchNumber);
				self.fruitPreparerFruitType = self.numberFillableFillTypeIndexToDesc[self.switchNumber];
				self.startTimer = true;
				self.renderHudFruit = true;
				self.hudTimer = 0;
			end;
			if self.newFruitNumbers >= 3 then
				if InputBinding.hasEvent(InputBinding.FruitSwitchLow) then
					self:fruitSwitched(false, self.switchNumber);
					self.fruitPreparerFruitType = self.numberFillableFillTypeIndexToDesc[self.switchNumber];
					self.startTimer = true;
					self.renderHudFruit = true;
					self.hudTimer = 0;
				end;
			end;
		end;
		
		if self.grainTankVehicle then
			if self.grainTankFillLevel >= self.grainTankCapacity*0.02 then
				self.allowedSwitch = false;
			else 
				self.allowedSwitch = true;
			end;
		end;
		
		if self.startTimer then
			self.hudTimer = self.hudTimer + dt;
			if self.hudTimer >= 3000 then
				self.renderHudFruit = false;
				self.hudTimer = 0;
				self.startTimer = false;
			end;
		end;

		
	end;
	

end;

function FruitNewPreparer:fruitSwitched(high, fruitNumber, noEventSend)
	if not noEventSend then
		FruitNewPreparerEvent.sendEvent(self, high, fruitNumber, noEventSend);
	end;
	
	if high then
		if fruitNumber == self.newFruitNumbers then
			self.switchNumber = 1;
		else
			self.switchNumber = fruitNumber + 1;
		end;
	else
		if fruitNumber == 1 then
			self.switchNumber = self.newFruitNumbers;
		else
			self.switchNumber = fruitNumber - 1;
		end;
	end;

	if self.aggregatesNew ~= nil then
		setVisibility(self.aggregatesNew[fruitNumber], false);
		setVisibility(self.aggregatesNew[self.switchNumber], true);
	end;
end;

function FruitNewPreparer:draw()
	if self:getIsActive() then
			if Fillable.fillTypeIndexToDesc[self.numberFillableFillTypeIndexToDesc[self.switchNumber]] ~= nil then
				g_currentMission:addExtraPrintText(string.format (g_i18n:getText("Current")..""..":   ".." "..Fillable.fillTypeIndexToDesc[self.numberFillableFillTypeIndexToDesc[self.switchNumber]].nameI18N));
			else
				g_currentMission:addExtraPrintText(string.format (g_i18n:getText("Current")..""..":   ".." "..self.numberFillableFillTypeIndexToDesc[self.switchNumber]));

			end;
			if self.allowedSwitch then
				g_currentMission:addHelpButtonText(g_i18n:getText("FruitSwitchHigh"), InputBinding.FruitSwitchHigh)
				if self.newFruitNumbers >= 3 then
					g_currentMission:addHelpButtonText(g_i18n:getText("FruitSwitchLow"), InputBinding.FruitSwitchLow)
				end;
				if self.renderHudFruit then
					if self.fruitOverlays[self.switchNumber] ~= nil then
						renderOverlay(self.fruitOverlays[self.switchNumber], 0.39, 0.895, 0.1, 0.1);
					end;
				end;
			end;
	end;
end;



FruitNewPreparerEvent = {};
FruitNewPreparerEvent_mt = Class(FruitNewPreparerEvent, Event);
InitEventClass(FruitNewPreparerEvent, "FruitNewPreparerEvent");

function FruitNewPreparerEvent:emptyNew()
	local self = Event:new(FruitNewPreparerEvent_mt);
	self.className="FruitNewPreparerEvent";
	return self;
end;

function FruitNewPreparerEvent:new(object, high, fruitNumber)
	local self = FruitNewPreparerEvent:emptyNew();
	self.object = object;
	self.high =  high;
	self.fruitNumber = fruitNumber;
	return self;
end;

function FruitNewPreparerEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.high);
	streamWriteInt8(streamId, self.fruitNumber);
end;

function FruitNewPreparerEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
    self.visible  = streamReadBool(streamId);
	self.high = streamReadInt8(streamId);
	self:run(connection);
end;

function FruitNewPreparerEvent:run(connection)
	self.object:fruitSwitched(self.high, self.fruitNumber, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(FruitNewPreparerEvent:new(self.object,self.high, self.fruitNumber), nil, connection, self.object);
	end;  
end;

function FruitNewPreparerEvent.sendEvent(object, high, fruitNumber, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(FruitNewPreparerEvent:new(object, high, fruitNumber), nil, nil, object);
		else 
			g_client:getServerConnection():sendEvent(FruitNewPreparerEvent:new(object, high, fruitNumber));
		end;
	end;
end;