-- ##########################################
-- #	Fortuna AT Function Script			#
-- #	version: 1.0						#
-- #	Date: 08.07.2014					#
-- #	author: [FSM]Chefkoch				#
-- #	hp: http://fsm-team.de				#
-- #										#
-- # 	Keine Vernderung ohne				# 
-- # 	meine Erlaubnis!					#
-- # 	No modification without				# 
-- # 	my permission!						#
-- #										#
-- #	history:							#
-- #	v1.0	Project started				#
-- #										#
-- ########################################## 


Fortuna_AT = {};

function Fortuna_AT.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Fortuna_AT:load(xmlFile)
	
	self.springs = {};
	
	local part1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.springs#movingPart1"));
	for _, part in pairs(self.movingParts) do
		if part.node == part1 then
			self.springs.part1 = part;
			break;
		end;
	end;
	
	local part2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.springs#movingPart2"));
	for _, part in pairs(self.movingParts) do
		if part.node == part2 then
			self.springs.part2 = part;
			break;
		end;
	end;	
	
	self.updateSprings = 100;
end;

function Fortuna_AT:delete()
end;

function Fortuna_AT:readStream(streamId, connection)
end;

function Fortuna_AT:writeStream(streamId, connection)
end;

function Fortuna_AT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fortuna_AT:keyEvent(unicode, sym, modifier, isDown)
end;

function Fortuna_AT:update(dt)

	if self:getIsActive() then
		self.updateSprings = 100;
	end;
	
	if self.updateSprings > 0 then
		Cylindered.updateMovingPart(self, self.springs.part1);	
		Cylindered.updateMovingPart(self, self.springs.part2);		
		self.updateSprings = self.updateSprings - 1;
	end;
	
end;

function Fortuna_AT:updateTick(dt)
end;

function Fortuna_AT:draw()
end;
