-- by "Marhu" 
-- v 1.0
-- Date: 21.05.2013
-- "Script zum entladen von Stckgut"

Cargo = {};

function Cargo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Cargo:load(xmlFile)
	self.updateTipping = Utils.overwrittenFunction(self.updateTipping, Cargo.updateTipping);
	self.CargoUnloadTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.GargoUnloadTime#value"), 1000);
	self.CargoUnloadTimeBackup = self.CargoUnloadTime;
	self.CargoUnloadTimePig = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.GargoUnloadTime#pig"), 1000);
	self.CargoUnloadTimeBeef = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.GargoUnloadTime#beef"), 1000);
	self.CargoUnloadTimeHorse = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.GargoUnloadTime#horse"), 1000);
	self.beefCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.beefcapacity"), 20);
	self.pigCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pigcapacity"), 32);
	self.horseCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.horsecapacity"), 32);
	
	self.hydraulicSounds = {};
	self.hydraulicSounds[1] = {};
	self.hydraulicSounds[2] = {};
	self.hydraulicSounds[3] = {};
	
	self.hydraulicSounds[1].file = getXMLString(xmlFile, "vehicle.hydraulicSoundBeef#file");
	self.hydraulicSounds[1].PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSoundBeef#pitchOffset"), 1.0);
	self.hydraulicSounds[1].Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSoundBeef#volume"), 1.0);

	self.hydraulicSounds[2].file = getXMLString(xmlFile, "vehicle.hydraulicSoundPig#file");
	self.hydraulicSounds[2].PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSoundPig#pitchOffset"), 1.0);
	self.hydraulicSounds[2].Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSoundPig#volume"), 1.0);

	self.hydraulicSounds[3].file = getXMLString(xmlFile, "vehicle.hydraulicSoundHorse#file");
	self.hydraulicSounds[3].PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSoundHorse#pitchOffset"), 1.0);
	self.hydraulicSounds[3].Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSoundHorse#volume"), 1.0);
	
	self.fillSounds = {};
	self.fillSounds[1] = {};
	self.fillSounds[2] = {};
	self.fillSounds[3] = {};

	self.fillSounds[1].file = getXMLString(xmlFile, "vehicle.fillSoundBeef#file");
	self.fillSounds[1].PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSoundBeef#pitchOffset"), 1.0);
	self.fillSounds[1].Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSoundBeef#volume"), 1.0);

	self.fillSounds[2].file = getXMLString(xmlFile, "vehicle.fillSoundPig#file");
	self.fillSounds[2].PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSoundPig#pitchOffset"), 1.0);
	self.fillSounds[2].Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSoundPig#volume"), 1.0);

	self.fillSounds[3].file = getXMLString(xmlFile, "vehicle.fillSoundHorse#file");
	self.fillSounds[3].PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSoundHorse#pitchOffset"), 1.0);
	self.fillSounds[3].Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSoundHorse#volume"), 1.0);
	
	self.capacityBackup = self.capacity;
	self.isSoundReinitDone = false;
end;

function Cargo:delete()
end;

function Cargo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Cargo:keyEvent(unicode, sym, modifier, isDown)
end;

function Cargo:update(dt)
	if self:getIsActive() then
		local reinitSound = 0;
		if self.fillLevel > 0 and self.isSoundReinitDone == false then
			self.capacity = self.capacityBackup;
			self.CargoUnloadTime = self.CargoUnloadTimeBackup;
			if self.currentFillType == Fillable.FILLTYPE_BEEF then
				self.capacity = self.beefCapacity;
				self.CargoUnloadTime = self.CargoUnloadTimeBeef;
				reinitSound = 1;
			elseif self.currentFillType == Fillable.FILLTYPE_PIG then
				self.capacity = self.pigCapacity;
				self.CargoUnloadTime = self.CargoUnloadTimePig;
				reinitSound = 2;
			elseif self.currentFillType == Fillable.FILLTYPE_HORSE then
				self.capacity = self.horseCapacity;
				self.CargoUnloadTime = self.CargoUnloadTimeHorse;
				reinitSound = 3;
			end;
		end;
		if self.fillLevel <= 0 then
			self.isSoundReinitDone = false;
		end;
		if reinitSound > 0 then
			if self.hydraulicSounds[reinitSound].file ~= nil and self.hydraulicSounds[reinitSound].file ~= "" then
				if self.hydraulicSound ~= nil then
					delete(self.hydraulicSound);
				end;
				local hydraulicSound  = Utils.getFilename(self.hydraulicSounds[reinitSound].file, self.baseDirectory);
				self.hydraulicSound = createSample("hydraulicSound");
				loadSample(self.hydraulicSound, hydraulicSound, false);
				self.hydraulicSoundPitchOffset = self.hydraulicSounds[reinitSound].PitchOffset;
				self.hydraulicSoundVolume = self.hydraulicSounds[reinitSound].Volume;
				setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset);
			end;
			if self.fillSounds[reinitSound].file ~= nil and self.fillSounds[reinitSound].file ~= "" then
				if self.fillSound ~= nil then
					delete(self.fillSound);
				end;
				local fillSound  = Utils.getFilename(self.fillSounds[reinitSound].file, self.baseDirectory);
				self.fillSound = createSample("fillSound");
				loadSample(self.fillSound, fillSound, false);
				self.fillSoundPitchOffset = self.fillSounds[reinitSound].PitchOffset;
				self.fillSoundVolume = self.fillSounds[reinitSound].Volume;
				setSamplePitch(self.fillSound, self.fillSoundPitchOffset);
			end;
		end;
	end;
end;

function Cargo:updateTipping(superFunc, dt)
	if not self.isServer then
		return;
	end;
	if self:getCanTip() then
		local fillType = self.currentFillType;
	   
		local fillDelta = -self.fillLevel;
		if self.currentTipReferencePointIndex ~= nil then
			local animation = self.tipAnimations[self.currentTipReferencePointIndex];
			if animation ~= nil and animation.dischargeEndTime > animation.dischargeStartTime then
				if self:getCurrentTipAnimationTime() >= animation.dischargeStartTime then
					local m = self.capacity/((animation.dischargeEndTime-animation.dischargeStartTime)/animation.animationOpenSpeedScale);
					fillDelta = -m * dt;
				else
					fillDelta = 0;
				end
			end
		end
	   
		if fillDelta < 0 then
			fillDelta = -1
			self.LoadTime = (self.LoadTime or 0) + dt
			if self.LoadTime >= self.CargoUnloadTime then
				self.LoadTime = 0
				local curFill = self.fillLevel;
				self:setFillLevel(self.fillLevel + fillDelta, fillType);
				local fillDelta = self.fillLevel - curFill;
				self.lastFillDelta = fillDelta;
		   
				if self.currentTipTrigger ~= nil then
					if self.currentTipTrigger.updateTrailerTipping ~= nil then
						self.currentTipTrigger:updateTrailerTipping(self, fillDelta, fillType);
					end
				elseif self:getCanTipToGround() then
					if fillDelta < 0 then
						local x, _,z = getWorldTranslation(self.groundDropArea.start);
						local x1,_,z1 = getWorldTranslation(self.groundDropArea.width);
						local x2,_,z2 = getWorldTranslation(self.groundDropArea.height);
		   
						local area = {x,z,x1,z1,x2,z2, -fillDelta*self.fillLevelToTippedFillLevel};
						local area, bitType, valueAccumulation = TrailerTipAreaEvent.runLocally(area, fillType, self.groundAmountAccumulation)
						if area ~= nil then
							g_server:broadcastEvent(TrailerTipAreaEvent:new(area, bitType, fillType));
						end;
						if valueAccumulation ~= nil then
							self.groundAmountAccumulation = valueAccumulation;
						end;
					end;
				end;
			end;
		end;
	else
		self:onEndTip();
	end;
end

function Cargo:draw()
end;