
-- MOD: AnimalHUD --																																																		
--	MOD Version: 2.4 --																																																				
-- MOD Author: DjiZoN And ZiDan --																																													
-- MOD date: 31.01.2013 --																																											
-- Copyright (C) DjiZoN --																																														
-- Contact via PM @ jasongagne@live.ca --																																															


AnimalHUD = {};
AnimalHUD.moddir=g_currentModDirectory;
AnimalHUD.modName = g_currentModName;
-- Config User --
-- Position the HUD -- 
PosX = 0.818; -- By default 0.818. For the left the screen 0.01. For the middle 0.50. For the Right 0.80 Approx... --
PosY = 0.835;-- By Default 0.835. For the Up 0.90. For The middle 0.50. For the Down 0.01 --
EggWarning = 50; -- By default 50 --
WoolWarning = 85; -- By default 85% --
SheepProductivityWarning = 34; -- By default 34% --
CowProductivityWarning = 34; -- By default 34 % --
LiquidManureStorageWarning = 790000; -- By default 790 000 --
SolidManureStorageWarning = 90000; -- By default 90 000 --
-- End config User --

function AnimalHUD:loadMap(name)
	self.AnimalHUDCount = 1;
	self.Overlay = {};
	self.Overlay.OverlayId = {};
	self.Overlay.Width = 0.179;
	self.Overlay.Height = 0.30;
	self.Overlay.PosX = PosX - 0.005;
	self.Overlay.PosY = PosY - 0.255;
	self.Overlay.OverlayId.ovid = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDChicken.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidS = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDChickenAndSheep.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidC = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDChickenAndCow.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidAll = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDAll.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING0 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG0.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING1 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG1.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING2 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG2.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING3 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG3.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING4 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG4.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING5 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG5.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING6 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG6.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING7 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG7.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING8 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG8.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING9 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG9.dds", AnimalHUD.moddir));
	self.Overlay.OverlayId.ovidWARNING10 = createImageOverlay(Utils.getFilename("Textures/OverlayAnimalHUDWARNIG10.dds", AnimalHUD.moddir));
end;


function AnimalHUD:deleteMap()
end;

function AnimalHUD:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimalHUD:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimalHUD:draw()
	local ValPosX = PosX + 0.112;
	local ValPosY = PosY;
	local fFontSize = 0.015;
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
	local Animals = g_currentMission.husbandries;
	local CM = g_currentMission;
	-- Overlay --
	if self.AnimalHUDCount == 1 then
		if self.Overlay.OverlayId.ovid ~= nil and self.Overlay.OverlayId.ovid ~= 0 then
			if Animals.chicken.totalNumAnimals >= 1 and Animals.sheep.totalNumAnimals <= 0 and Animals.cow.totalNumAnimals <= 0 then
				renderOverlay(self.Overlay.OverlayId.ovid, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			elseif Animals.sheep.totalNumAnimals >= 1 and Animals.cow.totalNumAnimals <= 0 then
				renderOverlay(self.Overlay.OverlayId.ovidS, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			elseif Animals.sheep.totalNumAnimals <= 0 and Animals.cow.totalNumAnimals >= 1 then
				renderOverlay(self.Overlay.OverlayId.ovidC, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			elseif Animals.sheep.totalNumAnimals >= 1 and Animals.cow.totalNumAnimals >= 1 then
				renderOverlay(self.Overlay.OverlayId.ovidAll, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height);
			end;
				
			-- Chicken --
			if Animals.chicken.totalNumAnimals > 0 then
				setTextColor(0,0,0,1);
				local lChickenOutput = "";
				local cChickenTotalNum = string.format("%1.0f", Animals.chicken.totalNumAnimals);
				lChickenOutput = g_i18n:getText("subCategory_chicken") .. ": " .. lChickenOutput;
				renderText(ValPosX, ValPosY, fFontSize, cChickenTotalNum); -- Valeur --
				renderText(PosX, PosY, fFontSize, lChickenOutput); -- subCategory_chicken --
				local i = 0.012;
				-- Egg Carriying --
				local lEggCarrying = "";
				local mission = g_currentMission;
				local cChickenEggCarrying = string.format("%1.0f", mission:getSiloAmount(Fillable.FILLTYPE_EGG));
				lEggCarrying = g_i18n:getText("Eggs_carrying") .. ": " .. lEggCarrying;
				renderText(ValPosX, ValPosY - (i), fFontSize, cChickenEggCarrying); -- Valeur --
				renderText(PosX, PosY - (i), fFontSize, lEggCarrying); -- Eggs_carrying --
				local i = i + 0.012;
				-- Egg Enclo --
				local lEggOutput = "";
				local cChickenEgg = string.format("%1.0f", Animals.chicken.numActivePickupObjects);
				if Animals.chicken.numActivePickupObjects >= EggWarning then
					setTextColor(1,0,0,1);
				end;
				lEggOutput = g_i18n:getText("egg") .. ": " .. lEggOutput;
				renderText(ValPosX, ValPosY - (i), fFontSize, cChickenEgg); -- Valeur -- 
				renderText(PosX, PosY - (i), fFontSize, lEggOutput) -- egg --
			end;	
			
			-- Sheep --
			if Animals.sheep.totalNumAnimals > 0 then
				local TotalSheep = Animals.sheep.totalNumAnimals + 1;
				setTextColor(0,0,0,1);
				local sPosY = PosY - 0.044;
				local sValPosY = ValPosY - 0.044;
				local lSheepOutput = "";
				local cSheepTotalNum = string.format("%1.0f", Animals.sheep.totalNumAnimals);
				lSheepOutput = g_i18n:getText("subCategory_sheep") .. ": " .. lSheepOutput;
				renderText(ValPosX, sValPosY, fFontSize, cSheepTotalNum); -- Valeur --
				renderText(PosX, sPosY, fFontSize, lSheepOutput) -- subCategory_sheep --
				local i = 0.012;
				-- Sheep Productivity --
				setTextColor(0,0,0,1);
				local lSheepProductivityOutput = "";
				local cSheepProductivity = round(Animals.sheep.productivity * 100);
				local cSheepProductivity2 = string.format("%1.0f", Animals.sheep.productivity * 100).. "% ";
				lSheepProductivityOutput = g_i18n:getText("Productivity") .. ": " .. lSheepProductivityOutput;
					if cSheepProductivity <= SheepProductivityWarning then
							setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, sValPosY - (i), fFontSize, cSheepProductivity2); -- Valeur --
				renderText(PosX, sPosY - (i), fFontSize, lSheepProductivityOutput); -- Productivity --
				local i = i + 0.012;
				-- Sheep Auge -- 
				setTextColor(0,0,0,1);
				local lSheepAugeOutput = "";
				local cSheepAuge = Animals.sheep:getFluidStatsText(Animals.sheep:getFillLevel(Fillable.FILLTYPE_FORAGE)).. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelSheepAuge = Animals.sheep:getFillLevel(Fillable.FILLTYPE_FORAGE);
				lSheepAugeOutput = g_i18n:getText("FeedingTroughMisc_storage") .. ": " .. lSheepAugeOutput;
					if FillLevelSheepAuge <= TotalSheep and FillLevelSheepAuge >= 1 then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, sValPosY - i , fFontSize, cSheepAuge); -- Valeur --
				renderText(PosX, sPosY - i , fFontSize, lSheepAugeOutput);	-- Auge --
				local i = i + 0.012;
				-- Sheep Wool Pallet --
				setTextColor(0,0,0,1);
				local lSheepWoolOutput = "";
				lSheepWoolOutput = g_i18n:getText("wool") .. ": " .. lSheepWoolOutput;	
				 if Animals.sheep.currentPallet == nil then
					cSheepWool2 ="0% ";
				else
					cSheepWool2 = string.format("%1.0f", 100 * Animals.sheep.currentPallet.fillLevel / Animals.sheep.currentPallet.capacity) .. "% ";
					local cSheepWool = round(Animals.sheep.currentPallet.fillLevel / Animals.sheep.currentPallet.capacity * 100)
					if cSheepWool >= WoolWarning then
						setTextColor(1,0,0,1);
					end;
				end;
				renderText(PosX, sPosY - i , fFontSize,  lSheepWoolOutput)
				renderText(ValPosX, sValPosY - i , fFontSize, cSheepWool2)
			end;	

			
			-- Cows --
			local cPosY = PosY - 0.044;
			local cValPosY = ValPosY - 0.044;
			if Animals.sheep.totalNumAnimals >= 1 then
				cPosY = PosY - 0.1;
				cValPosY = ValPosY - 0.1;
			end;
			if Animals.cow.totalNumAnimals >= 1 then
			local TotalCows = Animals.cow.totalNumAnimals * 10 + 1;
				setTextColor(0,0,0,1);
				local lCowOutput = "";
				local cCowTotalNum = string.format("%1.0f", Animals.cow.totalNumAnimals);
				lCowOutput = g_i18n:getText("subCategory_cow") .. ": " .. lCowOutput;
				renderText(ValPosX, cValPosY, fFontSize, cCowTotalNum); -- Valeur --
				renderText(PosX, cPosY, fFontSize, lCowOutput); -- Cows --
				-- Cow Productivity --
				setTextColor(0,0,0,1);
				local i = 0.012;
				local lCowProductivityOutput = "";
				local cCowProductivity = round(Animals.cow.productivity * 100);
				local cCowProductivity2 = string.format("%1.0f", Animals.cow.productivity * 100) .. "% ";
				lCowProductivityOutput = g_i18n:getText("Productivity") .. ": " .. lCowProductivityOutput;
					if cCowProductivity <= CowProductivityWarning then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, cValPosY - i, fFontSize, cCowProductivity2); -- Valeur --
				renderText(PosX, cPosY - i, fFontSize, lCowProductivityOutput); --  Productivity --
				-- Cow Auge (Melange) --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowAugeOutput = "";
				local lCowAugeEngOutput = "";
				local cCowAugeLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_FORAGE)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelAugeMelange = Animals.cow:getFillLevel(Fillable.FILLTYPE_FORAGE);
				lCowAugeOutput = g_i18n:getText("FeedingTroughForage_storage") .. ": " .. lCowAugeOutput;
					if g_i18n:getText("FeedingTroughForage_storage") == "Feeding trough (Mixed ration)" then
						lCowAugeOutput = "Feeding trough (Mixed):"
					end;
					if g_i18n:getText("FeedingTroughForage_storage") == "Mangiatoia (Razione mista)" then
					lCowAugeOutput = "Mangiatoia (Mista):"
					end;
					if FillLevelAugeMelange <= TotalCows and FillLevelAugeMelange >= 1 then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowAugeOutput); -- Auge (Melange) --
				-- Cow Auge (Fourrage Enssil) --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowAugeEnsileOutput = "";
				local cCowAugeEnsileLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_SILAGE)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelSilage = Animals.cow:getFillLevel(Fillable.FILLTYPE_SILAGE)
				lCowAugeEnsileOutput = g_i18n:getText("FeedingTroughSilage_storage") .. ": " .. lCowAugeEnsileOutput;
					if FillLevelSilage  <= TotalCows and FillLevelSilage >= 1 then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeEnsileLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowAugeEnsileOutput); --  (Fourrage Enssil) --
				-- Cow Auge (Herbe) --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowAugeHerbeOutput = "";
				local cCowAugeHerbeLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelHerbe = Animals.cow:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW)
				lCowAugeHerbeOutput = g_i18n:getText("FeedingTroughGrass_storage") .. ":" .. lCowAugeHerbeOutput;
					if FillLevelHerbe <= TotalCows and FillLevelHerbe >= 1 then
						setTextColor(1,0,0,1);
					end;
				renderText(PosX, cPosY - (i), fFontSize, lCowAugeHerbeOutput); -- Auge (Herbe) --
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowAugeHerbeLevel); -- Valeur --
				-- Cow Paille --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowPailleOutput = "";
				local cCowPailleLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_WHEAT_WINDROW)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelPaille = Animals.cow:getFillLevel(Fillable.FILLTYPE_WHEAT_WINDROW)
				lCowPailleOutput = g_i18n:getText("Straw_storage") .. ":" ..lCowPailleOutput;
					if FillLevelPaille <= TotalCows and FillLevelPaille >= 1 then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowPailleLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowPailleOutput); --  Paille --
				-- Cow Engrais Liquide --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowEngraisLiquideOutput = "";
				local cCowEngraisLiquideLevel = Animals.cow:getFluidStatsText(Animals.cow.liquidManureTrigger.fillLevel) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelEngraisLiquide = Animals.cow.liquidManureTrigger.fillLevel;
				lCowEngraisLiquideOutput = g_i18n:getText("LiquidManure_storage") .. ": " ..  lCowEngraisLiquideOutput;
					if FillLevelEngraisLiquide >= LiquidManureStorageWarning then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowEngraisLiquideLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowEngraisLiquideOutput); --  Engrais Liquide --
				-- Cow Engrais Solide --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowEngraisSolideOutput = "";
				local cCowEngraisSolideLevel = Animals.cow:getFluidStatsText(Animals.cow.manureHeap.fillLevel) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				local FillLevelEngraisSolide = Animals.cow.manureHeap.fillLevel;
				lCowEngraisSolideOutput = g_i18n:getText("Manure_storage") .. ": " ..  lCowEngraisSolideOutput;
					if FillLevelEngraisSolide >= SolidManureStorageWarning then
						setTextColor(1,0,0,1);
					end;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowEngraisSolideLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowEngraisSolideOutput); --  Engrais Solide --
				-- Cow Milk --
				setTextColor(0,0,0,1);
				local i = i + 0.012;
				local lCowMilkOutput = "";
				local cCowMilkLevel = Animals.cow:getFluidStatsText(Animals.cow.fillLevelMilk) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
				lCowMilkOutput = g_i18n:getText("Milk_storage") .. ":" .. lCowMilkOutput;
				renderText(ValPosX, cValPosY - (i), fFontSize, cCowMilkLevel); -- Valeur --
				renderText(PosX, cPosY - (i), fFontSize, lCowMilkOutput); --  Milk --
			end;	
		end;
	end;
	-- ------------------------------------------------------------------------------------------ Warning Compact HUD ------------------------------------------------------------------------------------- --
	if self.AnimalHUDCount == 2 then
		local TotalCows = Animals.cow.totalNumAnimals * 10 + 1;
		local WarningCount = 0;
		local i = 0;
		setTextColor(1,0,0,1);
		-- Eggs Warning --
		if Animals.chicken.numActivePickupObjects >= EggWarning then
			local lEggOutput = "";
			local cChickenEgg = string.format("%1.0f", Animals.chicken.numActivePickupObjects);
			lEggOutput = g_i18n:getText("egg") .. ":" .. cChickenEgg .. lEggOutput;
			WarningCount = WarningCount + 1;
			renderText(PosX, PosY - (i), fFontSize, lEggOutput) -- egg --
			i = i + 0.012;
		end;
		-- Sheep Warning --
		if Animals.sheep.totalNumAnimals > 0 then
		-- Sheep Productivity Warning --
			local cSheepProductivity = round(Animals.sheep.productivity * 100);
			if cSheepProductivity <= SheepProductivityWarning then
				local lSheepProductivityOutput = "";
				local cSheepProductivity2 = string.format("%1.0f", Animals.sheep.productivity * 100).. "% ";
				lSheepProductivityOutput = g_i18n:getText("subCategory_sheep") .. ":" .. g_i18n:getText("Productivity") .. ":" .. cSheepProductivity2 .. lSheepProductivityOutput;
				WarningCount = WarningCount + 1;
				renderText(PosX, PosY - (i), fFontSize, lSheepProductivityOutput) -- Warning Productivity Sheep --
				i =  i + 0.012;
			end;
			-- Sheep Pallet Warning --
			local lSheepWoolOutput = "";
			if Animals.sheep.currentPallet ~= nil then
				lSheepWoolOutput = g_i18n:getText("subCategory_sheep") .. ":" ..  g_i18n:getText("wool") .. ": " .. cSheepWool2 .. lSheepWoolOutput;	
				cSheepWool2 = string.format("%1.0f", 100 * Animals.sheep.currentPallet.fillLevel / Animals.sheep.currentPallet.capacity) .. "% ";
				local cSheepWool = round(Animals.sheep.currentPallet.fillLevel / Animals.sheep.currentPallet.capacity * 100)
				if cSheepWool >= WoolWarning then
					WarningCount = WarningCount + 1;
					renderText(PosX, PosY - (i) , fFontSize,  lSheepWoolOutput) -- Warning Wool Sheep --
					i = i + 0.012;
				end;
			end;
		end;
		if Animals.cow.totalNumAnimals >= 1 then
		-- Cows Productivity Warning -- 
			local cCowProductivity = round(Animals.cow.productivity * 100);
			if cCowProductivity <= CowProductivityWarning then
				local lCowProductivityWarningOutput = "";
				local cCowProductivity2 = string.format("%1.0f", Animals.cow.productivity * 100) .. "% ";
				lCowProductivityWarningOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("Productivity") .. ":" .. cCowProductivity2 .. lCowProductivityWarningOutput;
				WarningCount = WarningCount + 1;
				renderText(PosX, PosY - (i), fFontSize, lCowProductivityWarningOutput) -- Cow Productivity Warning --
				i = i + 0.012;
			end;
			-- Cows Auge Herbe --
			local lCowAugeHerbeOutput = "";
			local cCowAugeHerbeLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
			local FillLevelHerbe = Animals.cow:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW)
			lCowAugeHerbeOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("FeedingTroughGrass_storage") .. ":" .. cCowAugeHerbeLevel .. lCowAugeHerbeOutput;
			if FillLevelHerbe <= TotalCows and FillLevelHerbe >= 1 then
				WarningCount = WarningCount + 1;
				renderText(PosX, PosY - (i), fFontSize, lCowAugeHerbeOutput); -- Cows Auge Herbe Warning --
				i = i + 0.012;
			end;
			--  Cows Auge Fourrage Ensil -- 
			local lCowAugeEnsileOutput = "";
			local cCowAugeEnsileLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_SILAGE)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
			local FillLevelSilage = Animals.cow:getFillLevel(Fillable.FILLTYPE_SILAGE)
			lCowAugeEnsileOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("FeedingTroughSilage_storage") .. ":" .. cCowAugeEnsileLevel .. lCowAugeEnsileOutput;
			if FillLevelSilage  <= TotalCows and FillLevelSilage >= 1 then
				WarningCount = WarningCount + 1;
				renderText(PosX, PosY - (i), fFontSize, lCowAugeEnsileOutput); -- Cows Auge (Fourrage Enssil) Warning --
				i = i + 0.012;
			end;
			-- Cow Auge (Melange) --
			local lCowAugeOutput = "";
			local lCowAugeEngOutput = "";
			local cCowAugeLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_FORAGE)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
			local FillLevelAugeMelange = Animals.cow:getFillLevel(Fillable.FILLTYPE_FORAGE);
			lCowAugeOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("FeedingTroughForage_storage") .. ":" .. cCowAugeLevel.. lCowAugeOutput;
			if g_i18n:getText("FeedingTroughForage_storage") == "Feeding trough (Mixed ration)" then
				lCowAugeOutput = g_i18n:getText("subCategory_cow") .. ":" .. "Feeding trough (Mixed)" .. ":" .. cCowAugeLevel; -- English Shortcut --
			end;
			if g_i18n:getText("FeedingTroughForage_storage") == "Mangiatoia (Razione mista)" then
				lCowAugeOutput = g_i18n:getText("subCategory_cow") .. ":" .. "Mangiatoia (Mista)" .. ":" .. cCowAugeLevel; -- Italia Shortcut --
			end;
			if FillLevelAugeMelange <= TotalCows and FillLevelAugeMelange >= 1 then
				renderText(PosX, PosY - (i), fFontSize, lCowAugeOutput); -- Cow Auge (Melange) Warning --
				WarningCount = WarningCount + 1;
				i = i + 0.012;
			end;
			-- Cow Paille --
			local lCowPailleOutput = "";
			local cCowPailleLevel = Animals.cow:getFluidStatsText(Animals.cow:getFillLevel(Fillable.FILLTYPE_WHEAT_WINDROW)) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
			local FillLevelPaille = Animals.cow:getFillLevel(Fillable.FILLTYPE_WHEAT_WINDROW)
			lCowPailleOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("Straw_storage") .. ":" .. cCowPailleLevel .. lCowPailleOutput;
			if FillLevelPaille <= TotalCows and FillLevelPaille >= 1 then
				renderText(PosX, PosY - (i), fFontSize, lCowPailleOutput); --Cow Paille Warning --
				WarningCount = WarningCount + 1;
				i = i + 0.012;
			end;
			-- Cow Engrais Solide --
			local lCowEngraisSolideOutput = "";
			local cCowEngraisSolideLevel = Animals.cow:getFluidStatsText(Animals.cow.manureHeap.fillLevel) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
			local FillLevelEngraisSolide = Animals.cow.manureHeap.fillLevel;
			lCowEngraisSolideOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("Manure_storage") .. ":" .. cCowEngraisSolideLevel .. lCowEngraisSolideOutput;
			if FillLevelEngraisSolide >= SolidManureStorageWarning then
				renderText(PosX, PosY - (i), fFontSize, lCowEngraisSolideOutput); -- Cow Engrais Solide Warning --
				WarningCount = WarningCount + 1;
				i = i + 0.012;
			end;
			-- Cow Engrais Liquide --
			local lCowEngraisLiquideOutput = "";
			local cCowEngraisLiquideLevel = Animals.cow:getFluidStatsText(Animals.cow.liquidManureTrigger.fillLevel) .. "[" .. g_i18n:getText("fluid_unit_short") .. "]";
			local FillLevelEngraisLiquide = Animals.cow.liquidManureTrigger.fillLevel;
			lCowEngraisLiquideOutput = g_i18n:getText("subCategory_cow") .. ":" .. g_i18n:getText("LiquidManure_storage") .. ":" .. cCowEngraisLiquideLevel .. lCowEngraisLiquideOutput;
			if FillLevelEngraisLiquide >= LiquidManureStorageWarning then
				renderText(PosX, PosY - (i), fFontSize, lCowEngraisLiquideOutput); -- Cow Engrais Liquide Warning --
				WarningCount = WarningCount + 1;
				i = i + 0.012;
			end;
		end;
		-- WarningCount --
		if WarningCount == 0 then renderOverlay(self.Overlay.OverlayId.ovidWARNING0, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 1 then renderOverlay(self.Overlay.OverlayId.ovidWARNING1, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 2 then renderOverlay(self.Overlay.OverlayId.ovidWARNING2, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 3 then renderOverlay(self.Overlay.OverlayId.ovidWARNING3, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;	
		if WarningCount == 4 then renderOverlay(self.Overlay.OverlayId.ovidWARNING4, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;	
		if WarningCount == 5 then renderOverlay(self.Overlay.OverlayId.ovidWARNING5, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 6 then renderOverlay(self.Overlay.OverlayId.ovidWARNING6, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 7 then renderOverlay(self.Overlay.OverlayId.ovidWARNING7, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 8 then renderOverlay(self.Overlay.OverlayId.ovidWARNING8, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 9 then renderOverlay(self.Overlay.OverlayId.ovidWARNING9, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
		if WarningCount == 10 then renderOverlay(self.Overlay.OverlayId.ovidWARNING10, self.Overlay.PosX, self.Overlay.PosY, self.Overlay.Width, self.Overlay.Height); end;
	end;
end;

function round(num, idp)
	if Utils.getNoNil(num, 0) > 0 then
		local mult = 10^(idp or 0);
		return math.floor(num * mult + 0.5) / mult;
	else 
		return 0;
	end;
end; 

function AnimalHUD:update(dt)
	if InputBinding.hasEvent(InputBinding.Animal_TOGGLE) then
		self.AnimalHUDCount = self.AnimalHUDCount +1;
			if self.AnimalHUDCount == 3 then
				self.AnimalHUDCount = 0;
			end;
	end;
end;

addModEventListener(AnimalHUD);