
moveAttach = {};

function moveAttach.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveAttach:load(xmlFile)

	self.moveableAttach = {};
	self.moveableAttach.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttach#index"));
	self.moveableAttach.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttach#maxY"), 0); 
	self.moveableAttach.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttach#minY"), 0); 
	
end;

function moveAttach:delete()
end;

function moveAttach:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveAttach:keyEvent(unicode, sym, modifier, isDown)

end;

function moveAttach:update(dt)

	if self.moveableAttach ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttach.index);
		local maxY = self.moveableAttach.max;
		local minY = self.moveableAttach.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.ATTACHER_UP) then
				if yAttacher < maxY then
					yAttacher = yAttacher + moveSpeed;
				else
					yAttacher = maxY;
				end;
			elseif InputBinding.isPressed(InputBinding.ATTACHER_DOWN) then
				if yAttacher > minY then
					yAttacher = yAttacher - moveSpeed;
				else
					yAttacher = minY;
				end;
			end;
		setTranslation(self.moveableAttach.index, xAttacher, yAttacher, zAttacher);
	end;
				
end;

function moveAttach:onLeave()

end;

function moveAttach:draw()
	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("ATTACHER_CONTROLS"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ATTACHER_UP) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ATTACHER_DOWN));
end;

function moveAttach:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

