Field_Bin = {};

function Field_Bin.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(PowerShaft, specializations);
end;

function Field_Bin:load(xmlFile)

	self.setUnloadingState = SpecializationUtil.callSpecializationsFunction("setUnloadingState");
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.trailerRaycastCallback = Field_Bin.trailerRaycastCallback;

	self.triggerNode = {};
	self.triggerNode.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.unloadingTrigger#node"));
	self.triggerNode.distance = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.unloadingTrigger#maxDistance"), 1);
	self.unloadingTipTrigger = nil;
	
	self.pipe = {};
	self.pipe.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
	self.pipe.distance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#raycastDistance"), 7);
	self.pipe.out = false;
	
	self.unloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.unloadingCapacity"), 100);
	self.saveMinRpm = 0;
	self.allowFillFromAir = false;
	self.isUnloading = false;
	
	self.isLoading = true;
	
	local path = Utils.getFilename("overlay.png", self.baseDirectory);
    self.unloadingOverlay = Overlay:new("hudPDAControl", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize, g_currentMission.fruitSymbolSize * (4 / 3)); 
    self.printWarningTime = 0;

	self.setDoorOne = SpecializationUtil.callSpecializationsFunction("setDoorOne");
	self.DoorOneAnimation = getXMLString(xmlFile, "vehicle.DoorOne#animationName");
	self.DoorOne = false;
	self.setWheelRot = SpecializationUtil.callSpecializationsFunction("setWheelRot");
	self.WheelRotAnimation = getXMLString(xmlFile, "vehicle.WheelRot#animationName");
	self.WheelRot = false;
	self.setDoorTwo = SpecializationUtil.callSpecializationsFunction("setDoorTwo");
	self.DoorTwoAnimation = getXMLString(xmlFile, "vehicle.DoorTwo#animationName");
	self.DoorTwo = false;
	self.binNode = {};
	self.binNode.node  = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.binNode#index"));

    self.printWarningTime = 0;
    self.printWarningTime1 = 0;	
end;

function Field_Bin:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isWheelRotOn = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isWheelRotOn"), false);
		if isWheelRotOn ~= nil then
			self:setWheelRot(isWheelRotOn);
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Field_Bin:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'isWheelRotOn="' .. tostring(self.isWheelRotOn) ..'"';	
	attributes = attributes .. mystring;

    local node = nil;
	return attributes, node;
end;

function Field_Bin:delete()

end;

function Field_Bin:readStream(streamId, connection)
	self.isLoading = true;
	local isUnloading = streamReadBool(streamId);
	self:setUnloadingState(isUnloading, true);
    self:setWheelRot(streamReadBool(streamId), true); 
    self:setDoorOne(streamReadBool(streamId), true);
    self:setDoorTwo(streamReadBool(streamId), true);
end;

function Field_Bin:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isUnloading);
    streamWriteBool(streamId, self.WheelRot);
    streamWriteBool(streamId, self.DoorOne);
    streamWriteBool(streamId, self.DoorTwo);
end;

function Field_Bin:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Field_Bin:keyEvent(unicode, sym, modifier, isDown)
end;

function Field_Bin:update(dt)
	if not self:getIsActive() then
		if self.binInRange then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self:setDoorOne(not self.isDoorOneOn);
			end;
			if self.isDoorOneOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Close_DoorOne"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Open_DoorOne"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
			end;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setDoorTwo(not self.isDoorTwoOn);
			end;
			if self.isDoorTwoOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Close_DoorTwo"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Open_DoorTwo"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;	
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) and self.fillLevel == 0 then
					self:setWheelRot(not self.isWheelRotOn);
			end;
			if self.fillLevel == 0 then
				if not self.isWheelRotOn then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("transport"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("field"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
				end;
			end;
		end;		
	end;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and not self.PTOId then
			self:setUnloadingState(not self.isUnloading);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.PTOId then
				self.printWarningTime = self.time + 1000;
		end;
	end;

	if self.isWheelRotOn and not (self.isDoorOneOn or self.isDoorTwoOn) then	
		self.allowFillFromAir = false;
	end;
	if not self.isWheelRotOn and (self.isDoorOneOn or self.isDoorTwoOn)	then
		self.allowFillFromAir = true;
	end;
	
	self.pipe.out = true;
	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	
end;

function Field_Bin:updateTick(dt)
	if g_currentMission.player ~= nil then
		local nearestDistance = 6;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);		
		local px, py, pz = getWorldTranslation(self.binNode.node); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.binInRange = true; 
		else
			self.binInRange = false; 
		end;
	end;

	self.trailerFoundId = 0;
	self.unloadingTipTrigger = nil;
	
	if self.fillLevel > 0 and self.pipe.out then
		for k, tipTrigger in pairs(g_currentMission.tipTriggers) do
			local trailerX, trailerY, trailerZ = getWorldTranslation(self.triggerNode.index);
			local triggerX, triggerY, triggerZ = getWorldTranslation(tipTrigger.triggerId);
			local distance = Utils.vector3Length(trailerX-triggerX, trailerY-triggerY, trailerZ-triggerZ);
			if distance < self.triggerNode.distance then
				self.unloadingTipTrigger = tipTrigger;
			end;
		end;
		if self.unloadingTipTrigger == nil then
			local x, y, z = getWorldTranslation(self.pipe.node);
			local dx, dy, dz = localDirectionToWorld(self.pipe.node, 0, -0.5, 0);
			raycastAll(x, y, z, dx, dy, dz, "trailerRaycastCallback", self.pipe.distance, self);
		end;
	end;
	
	if self:getIsActive() then
		if not self.attacherVehicle.isMotorStarted then 
			self:setUnloadingState(false);
		end;
		if self.PTOId then
			self:setUnloadingState(false);
		end
 
		local renderOverlay = false;
		local deltaLevel = 0;
		if self.trailerFoundId ~= nil and self.trailerFoundId ~= 0 then
			local trailer = g_currentMission.nodeToVehicle[self.trailerFoundId];
			if trailer ~= nil and trailer ~= self and trailer:allowFillType(self.currentFillType, true) and trailer.allowFillFromAir and trailer.capacity ~= trailer.fillLevel then
				if self.isUnloading then
					deltaLevel = math.min(self.unloadingCapacity*dt/1000.0, trailer.capacity-trailer.fillLevel);
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
				else
					renderOverlay = true;
				end;
			elseif self.isUnloading then
				self:setUnloadingState(false);
			end;
		elseif self.unloadingTipTrigger ~= nil then
			local tipTrigger = self.unloadingTipTrigger;
			local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
			local fruitAccept = tipTrigger.acceptedFruitTypes[fruitType];
			if tipTrigger.isFarmTrigger and fruitAccept then
				if self.isUnloading then
					deltaLevel = self.unloadingCapacity*dt/1000.0;
					g_currentMission.missionStats.farmSiloAmounts[self.currentFillType] = g_currentMission.missionStats.farmSiloAmounts[self.currentFillType] + deltaLevel;
				else
					renderOverlay = true;
				end;
			elseif fruitAccept then
				if self.isUnloading then
					deltaLevel = self.unloadingCapacity*dt/1000.0;
					local priceMultiplier = tipTrigger.priceMultipliers[fruitType];
					local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local money = FruitUtil.fruitIndexToDesc[fruitType].pricePerLiter * priceMultiplier * difficultyMultiplier * deltaLevel;
					g_currentMission:addSharedMoney(money);
				else
					renderOverlay = true;
				end;
			else
				if FruitUtil.fruitIndexToDesc[fruitType].name ~= nil then
					g_currentMission:addWarning(g_i18n:getText(FruitUtil.fruitIndexToDesc[fruitType].name) .. g_i18n:getText("notAcceptedHere"), 0.018, 0.033);
				end;
			end;
			if deltaLevel > 0 then
				tipTrigger:updateMoving(deltaLevel);
			end;
		elseif self.isUnloading then
			self:setUnloadingState(false);
		end;
		self.fillLevel = self.fillLevel-deltaLevel;
		if deltaLevel == 0 and self.isUnloading then
			self:setUnloadingState(false);
		end;
		if self.fillLevel <= 0.0 then
			self.fillLevel = 0.0;
			if self.isUnloading then
				self:setUnloadingState(false);
			end;
			Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.isUnloading);
			self.currentFillType = Fillable.FRUITTYPE_UNKNOWN;
		end;
		self:setFillLevel(self.fillLevel, self.currentFillType);
		self.renderOverlay = renderOverlay;
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.isUnloading);
		self:setVehicleRpmUp(dt, self.isUnloading);
	end;

end;

function Field_Bin:trailerRaycastCallback(transformId, x, y, z, distance)
	local vehicle = g_currentMission.nodeToVehicle[transformId];
	if vehicle ~= nil then
		if vehicle.exactFillRootNode == transformId then
			self.trailerFoundId = transformId;
			return false;
		end;
	end;
	return true;
end;

function Field_Bin:setUnloadingState(state, noEventSend)
	SetUnloadingEvent.sendEvent(self, state, noEventSend);
	self.isUnloading = state;
end;

function Field_Bin:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function Field_Bin:draw()	
	if self:getIsActive() then
		if self.isUnloading then
			g_currentMission:addHelpButtonText(g_i18n:getText("DeactivateAuger"), InputBinding.IMPLEMENT_EXTRA);
		elseif self.renderOverlay then
			self.unloadingOverlay:render();
			g_currentMission:addHelpButtonText(g_i18n:getText("ActivateAuger"), InputBinding.IMPLEMENT_EXTRA);
		end;

		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
	end;
	
	if self.isClient then
		if not self.isWheelRotOn and self.lastSpeed*3600 > 2 then
			g_currentMission:addWarning(g_i18n:getText("moving_Error"), 0.018, 0.033);
		end;
	end;
end;

function Field_Bin:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function Field_Bin:onDetach()
	if self.deactivateOnDetach then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
	self:setWheelRot(false,true);
end;

function Field_Bin:onLeave()
	if self.deactivateOnLeave then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	
end;

function Field_Bin:onDeactivate()
	self:setUnloadingState(false);
	self.unloadingTipTrigger = nil;
	self:setVehicleRpmUp(nil, false);
	for k, particle in pairs(self.dischargeParticleSystems) do
		Utils.setEmittingState(particle, false);
	end;
end;

function Field_Bin:onDeactivateSounds()

end;

function Field_Bin:setWheelRot(isWheelRot,noEventSend)
	SetWheelRotEvent.sendEvent(self, isWheelRot, noEventSend);
	-- Play WheelRot animation --
	self.isWheelRotOn = isWheelRot;
	if self.isWheelRotOn then
		if self.WheelRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.WheelRotAnimation, 1, nil, true);
			self.WheelRot = true;
		end;
	else
		if self.WheelRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.WheelRotAnimation, -1, nil, true);
			self.WheelRot = false;
		end;
	end;
end;

function Field_Bin:setDoorOne(isDoorOne,noEventSend)
	SetDoorOneEvent.sendEvent(self, isDoorOne, noEventSend);
	-- Play DoorOne animation --
	self.isDoorOneOn = isDoorOne;
	if self.isDoorOneOn then
		if self.DoorOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DoorOneAnimation, 1, nil, true);
			self.DoorOne = true;
		end;
	else
		if self.DoorOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DoorOneAnimation, -1, nil, true);
			self.DoorOne = false;
		end;
	end;	
end;

function Field_Bin:setDoorTwo(isDoorTwo,noEventSend)
	SetDoorTwoEvent.sendEvent(self, isDoorTwo, noEventSend);
	-- Play DoorTwo animation --
	self.isDoorTwoOn = isDoorTwo;
	if self.isDoorTwoOn then
		if self.DoorTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DoorTwoAnimation, 1, nil, true);
			self.DoorTwo = true;
		end;
	else
		if self.DoorTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DoorTwoAnimation, -1, nil, true);
			self.DoorTwo = false;  
		end;
	end;
end;

SetWheelRotEvent = {};
SetWheelRotEvent_mt = Class(SetWheelRotEvent, Event);

InitEventClass(SetWheelRotEvent, "SetWheelRotEvent");

function SetWheelRotEvent:emptyNew()
    local self = Event:new(SetWheelRotEvent_mt);
    self.className="SetWheelRotEvent";
    return self;
end;

function SetWheelRotEvent:new(vehicle, isWheelRot)
    local self = SetWheelRotEvent:emptyNew()
    self.vehicle = vehicle;
	self.isWheelRot = isWheelRot;
    return self;
end;

function SetWheelRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isWheelRot = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetWheelRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isWheelRot);
end;

function SetWheelRotEvent:run(connection)   
	self.vehicle:setWheelRot(self.isWheelRot, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetWheelRotEvent:new(self.vehicle, self.isWheelRot), nil, connection, self.vehicle);
    end;
end;

function SetWheelRotEvent.sendEvent(vehicle, isWheelRot, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWheelRotEvent:new(vehicle, isWheelRot), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWheelRotEvent:new(vehicle, isWheelRot));
		end;
	end;
end;

SetDoorTwoEvent = {};
SetDoorTwoEvent_mt = Class(SetDoorTwoEvent, Event);

InitEventClass(SetDoorTwoEvent, "SetDoorTwoEvent");

function SetDoorTwoEvent:emptyNew()
    local self = Event:new(SetDoorTwoEvent_mt);
    self.className="SetDoorTwoEvent";
    return self;
end;

function SetDoorTwoEvent:new(vehicle, isDoorTwo)
    local self = SetDoorTwoEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDoorTwo = isDoorTwo;
    return self;
end;

function SetDoorTwoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDoorTwo = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDoorTwoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDoorTwo);
end;

function SetDoorTwoEvent:run(connection)   
	self.vehicle:setDoorTwo(self.isDoorTwo, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorTwoEvent:new(self.vehicle, self.isDoorTwo), nil, connection, self.vehicle);
    end;
end;

function SetDoorTwoEvent.sendEvent(vehicle, isDoorTwo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDoorTwoEvent:new(vehicle, isDoorTwo), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDoorTwoEvent:new(vehicle, isDoorTwo));
		end;
	end;
end;

SetDoorOneEvent = {};
SetDoorOneEvent_mt = Class(SetDoorOneEvent, Event);

InitEventClass(SetDoorOneEvent, "SetDoorOneEvent");

function SetDoorOneEvent:emptyNew()
    local self = Event:new(SetDoorOneEvent_mt);
    self.className="SetDoorOneEvent";
    return self;
end;

function SetDoorOneEvent:new(vehicle, isDoorOne)
    local self = SetDoorOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDoorOne = isDoorOne;
    return self;
end;

function SetDoorOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDoorOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDoorOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDoorOne);
end;

function SetDoorOneEvent:run(connection)   
	self.vehicle:setDoorOne(self.isDoorOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorOneEvent:new(self.vehicle, self.isDoorOne), nil, connection, self.vehicle);
    end;
end;

function SetDoorOneEvent.sendEvent(vehicle, isDoorOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDoorOneEvent:new(vehicle, isDoorOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDoorOneEvent:new(vehicle, isDoorOne));
		end;
	end;
end;
