--
-- BuyabletwinWheightAttacher
-- Specialization for BuyabletwinWheightAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- -- @ Ago-Systemtech   -fix for wheight rear mount--- 01/10/2012---(TIF )
---

BuyabletwinWheightAttacher = {};

function BuyabletwinWheightAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyabletwinWheightAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyabletwinWheight = {};
	self.buyabletwinWheight.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheightCheckString"), "standart");
	self.buyabletwinWheight.twinWheight = nil;
	self.buyabletwinWheight.wheelsInRange = nil;	
end;

function BuyabletwinWheightAttacher:delete()
	if self.buyabletwinWheight.twinWheight ~= nil then
		self.buyabletwinWheight.twinWheight:disassembleWheels(true);
	end;
end;

function BuyabletwinWheightAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyabletwinWheightAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyabletwinWheightAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyabletwinWheight;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.compra_twinWheight) then
					if wheels.twinWheight == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheightUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyabletwinWheightAttacher:draw()
	local wheels = self.buyabletwinWheight;
	if wheels.wheelsInRange ~= nil then
		if wheels.twinWheight ~= nil then
			if wheels.wheelsInRange.twinWheightUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyabletwinWheight_disassemble"), InputBinding.compra_twinWheight);
			end;
		else
			if wheels.wheelsInRange.twinWheightUser == nil then
			g_currentMission:addHelpButtonText(g_i18n:getText("BuyabletwinWheight_assemble"), InputBinding.compra_twinWheight);
			end;
		end;
	end;
end;

function BuyabletwinWheightAttacher:onAssembling(buyabletwinWheight)
	self.buyabletwinWheight.twinWheight = buyabletwinWheight;
end;

function BuyabletwinWheightAttacher:onDisassembling()
	self.buyabletwinWheight.twinWheight = nil;
end;
