SetRealLight_RevIsPressedEvent = {};
SetRealLight_RevIsPressedEvent_mt = Class(SetRealLight_RevIsPressedEvent, Event);

InitEventClass(SetRealLight_RevIsPressedEvent, "SetRealLight_RevIsPressedEvent");

function SetRealLight_RevIsPressedEvent:emptyNew()
    local self = Event:new(SetRealLight_RevIsPressedEvent_mt);
    self.className="SetRealLight_RevIsPressedEvent";
    return self;
end;
		 
function SetRealLight_RevIsPressedEvent:new(vehicle, state)
    local self = SetRealLight_RevIsPressedEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetRealLight_RevIsPressedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRealLight_RevIsPressedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetRealLight_RevIsPressedEvent:run(connection)
	self.vehicle:setRevIsPressed(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRealLight_RevIsPressedEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetRealLight_RevIsPressedEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRealLight_RevIsPressedEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRealLight_RevIsPressedEvent:new(vehicle, state));
		end;
	end;
end;