SetRealLight_BlinkerREvent = {};
SetRealLight_BlinkerREvent_mt = Class(SetRealLight_BlinkerREvent, Event);

InitEventClass(SetRealLight_BlinkerREvent, "SetRealLight_BlinkerREvent");

function SetRealLight_BlinkerREvent:emptyNew()
    local self = Event:new(SetRealLight_BlinkerREvent_mt);
    self.className="SetRealLight_BlinkerREvent";
    return self;
end;

function SetRealLight_BlinkerREvent:new(vehicle, state)
    local self = SetRealLight_BlinkerREvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetRealLight_BlinkerREvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRealLight_BlinkerREvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetRealLight_BlinkerREvent:run(connection)
	self.vehicle:setBlinkerRState(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRealLight_BlinkerREvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetRealLight_BlinkerREvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRealLight_BlinkerREvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRealLight_BlinkerREvent:new(vehicle, state));
		end;
	end;
end;