Sipma = {};

function Sipma.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function Sipma:load(xmlFile)
    self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.moveBalesOutForTransport = Sipma.moveBalesOutForTransport;
	self.allowPickingUp = Utils.overwrittenFunction(self.allowPickingUp, Sipma.allowPickingUp);
	self.setBaleTime = Baler.setBaleTime;

	self.setBackFlap = SpecializationUtil.callSpecializationsFunction("setBackFlap");
	self.resetBaleCounter = SpecializationUtil.callSpecializationsFunction("resetBaleCounter");
	self.setRopePanel = SpecializationUtil.callSpecializationsFunction("setRopePanel");
	self.setHasRopes = SpecializationUtil.callSpecializationsFunction("setHasRopes");
	self.moveBalesOut = SpecializationUtil.callSpecializationsFunction("moveBalesOut");
	self.doMoveBalesOut = SpecializationUtil.callSpecializationsFunction("doMoveBalesOut");

	self.backFlap = false;
	
	local pickupNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pickupNode#index"));
	if pickupNode ~= nil then
		self.pickupNode = pickupNode;
	end;
	
	local attacherNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherNode#index"));
	if attacherNode ~= nil then
		self.attacherNode = attacherNode;
	end;
	
	local backOptionsNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backOptionsNode#index"));
	if backOptionsNode ~= nil then
		self.backOptionsNode = backOptionsNode;
	end;
	
	self.pickupWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pickupWheel#index"));
	self.baleStarNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleStar#index"));
	self.baleStarSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.baleStar#speed"), 1);

	self.strawParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.strawParticleSystems.strawParticleSystem(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local strawParticleSystem = {};
			strawParticleSystem.particleSystem = {};
			local isStatic = Utils.getNoNil(getXMLBool(xmlFile, key.."#static"), false);
			if isStatic then
				StaticParticleSystem.loadParticleSystem(xmlFile, strawParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			else
				Utils.loadParticleSystem(xmlFile, strawParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			end;
			table.insert(self.strawParticleSystems, strawParticleSystem);
		end;
		i = i+1;
	end;
	self.grassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.grassParticleSystems.grassParticleSystem(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local grassParticleSystem = {};
			grassParticleSystem.particleSystem = {};
			local isStatic = Utils.getNoNil(getXMLBool(xmlFile, key.."#static"), false);
			if isStatic then
				StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			else
				Utils.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			end;
			table.insert(self.grassParticleSystems, grassParticleSystem);
		end;
		i = i+1;
	end;
	
	self.soundOffset = 0;
    local balerStopSound = getXMLString(xmlFile, "vehicle.balerStopSound#file");
    if balerStopSound ~= nil and balerStopSound ~= "" then
        balerStopSound = Utils.getFilename(balerStopSound, self.baseDirectory);
        self.balerStopSound = createSample("balerStopSound");
        loadSample(self.balerStopSound, balerStopSound, false);
        self.balerStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehiclebalerStopSound#pitchOffset"), 1);
        self.balerStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerSound#volume"), 1.0);
    end;

    local balerStartSound = getXMLString(xmlFile, "vehicle.balerStartSound#file");
    if balerStartSound ~= nil and balerStartSound ~= "" then
        balerStartSound = Utils.getFilename(balerStartSound, self.baseDirectory);
        self.balerStartSound = createSample("balerStartSound");
        loadSample(self.balerStartSound, balerStartSound, false);
        self.balerStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerStartSound#pitchOffset"), 1);
        self.balerStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerStartSound#volume"), 1.0);
    end;
	
	local balerAISound = getXMLString(xmlFile, "vehicle.balerAISound#file");
		if balerAISound ~= nil and balerAISound ~= "" then
		balerAISound = Utils.getFilename(balerAISound, self.baseDirectory);
		self.balerAISoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerAISound#pitchOffset"), 0);
		self.balerAISoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerAISound#radius"), 50);
		self.balerAISoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerAISound#innerRadius"), 10);
		self.balerAISoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerAISound#volume"), 1);
		self.balerAISound = createAudioSource("balerAISound", balerAISound, self.balerAISoundRadius, self.balerAISoundInnerRadius, self.balerAISoundVolume, 0);
		link(self.components[1].node, self.balerAISound);
		setVisibility(self.balerAISound, false);
	end;
	
	self.File = Utils.getFilename("Textures/hud.dds", self.baseDirectory);
	self.hudPoxX = 0.685;
    self.hudPoxY = 1-0.066; 
    self.hudWidth = 0.13325;
    self.hudHeight = 0.0513825;
    self.HUDSipma = Overlay:new("HUDSipma", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
    self.HUD = false;
	
	self.TotalBalesCount = 0;
	self.CurrentBalesCount = 0;
	self.NoRopesBalesCount = 0;
	self.lastBaleCount = 0;
	
	self.moveBalesOutsideForTransport = false;
	self.doResetBaleCounter = false;
	
	self.ropePanelAnimation = getXMLString(xmlFile, "vehicle.ropePanel#animationName");
	self.ropePanel = true;
	
	local ropeDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ropePanel#index"));
	if ropeDoor ~= nil then
		self.ropeDoor = ropeDoor;
	end;
	
	self.ropes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ropes#index"));
	self.ropesCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ropes#capacity"), 4);
	self.hasRopes = true;
	self.isLoaded = true;
	
    NoRopeSoundFile = Utils.getFilename("Sounds/NoRope.ogg", self.baseDirectory);
    self.NoRopeSoundId = createSample("NoRopeSound");
    loadSample(self.NoRopeSoundId, NoRopeSoundFile, false);
    self.NoRopePlaying = false;
	
	self.moveBalesOutside = true;
	self.doMoveBalesOutside = false;
	self.firstTimeStart = true;
	
	self.lastfill = self.fillLevel;
	self.lastAreaBiggerZero = false;
   -- end new --  
end;

function Sipma:delete()
	-- new --
	if self.balerStopSound ~= nil then
        delete(self.balerStopSound);
		self.balerStopSound = nil;
    end;
	if self.balerStartSound ~= nil then
        delete(self.balerStartSound);
		self.balerStartSound = nil;
    end;

    if self.NoRopeSound ~= nil then
        delete(self.NoRopeSound);
    end;
	for k, strawParticleSystem in pairs(self.strawParticleSystems) do
		Utils.deleteParticleSystem(strawParticleSystem.particleSystem);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.deleteParticleSystem(grassParticleSystem.particleSystem);
	end;
end;

function Sipma:readStream(streamId, connection)
	self:setBackFlap(streamReadBool(streamId), true);
	self:resetBaleCounter(streamReadBool(streamId), true);

    self.TotalBalesCount = streamReadInt32(streamId);
    self.NoRopesBalesCount = streamReadInt32(streamId);
    self.CurrentBalesCount = streamReadInt32(streamId);
	self:setRopePanel(streamReadBool(streamId), true);
    self:setHasRopes(streamReadBool(streamId), true);
end;

function Sipma:writeStream(streamId, connection)
	streamWriteBool(streamId, self.backFlap);
	streamWriteBool(streamId, self.doResetBaleCounter);

    streamWriteInt32(streamId, self.TotalBalesCount);
    streamWriteInt32(streamId, self.NoRopesBalesCount);
    streamWriteInt32(streamId, self.CurrentBalesCount);
	streamWriteBool(streamId, self.ropePanel);
    streamWriteBool(streamId, self.isLoaded);
end;

function Sipma:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local numBales = Utils.getNoNil(getXMLInt(xmlFile, key.."#numBales"),0);
	local TotalBalesCount = Utils.getNoNil(getXMLInt(xmlFile, key.."#totalBalesCount"),0);
	local NoRopesBalesCount = Utils.getNoNil(getXMLInt(xmlFile, key.."#noRopesBalesCount"),0);
	self.lastBaleCount = numBales;
	self.TotalBalesCount = TotalBalesCount;
	self.NoRopesBalesCount = NoRopesBalesCount;
	
	if not resetVehicles then
		if self.animationParts[6].isLoading and self.animationParts[6].inputTime > self.animationParts[6].offSet then
			self:setBackFlap(true);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end

function Sipma:getSaveAttributesAndNodes(nodeIdent)
	local TotalBalesCount = Utils.getNoNil(self.TotalBalesCount, 0);
	local NoRopesBalesCount = Utils.getNoNil(self.NoRopesBalesCount, 0);
	local attributes = 'totalBalesCount="'..string.format("%d",TotalBalesCount)..'" noRopesBalesCount="'..string.format("%d",NoRopesBalesCount)..'"';
	return attributes,nodes;
end

function Sipma:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Sipma:keyEvent(unicode, sym, modifier, isDown)
end;

function Sipma:update(dt)
	if self.firstTimeStart then
		self.firstTimeStart = false;
	end;
	
	if self.animationParts[6].clipStartTime then
		self.isTurnedOn = false;
	end;
	
	
	if self:getIsActiveForInput() then		
		if InputBinding.hasEvent(InputBinding.Sipma_LOWER_PICKUP) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			else
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;

		if self.isTurnedOn == false then
			if InputBinding.hasEvent(InputBinding.Sipma_WORK_MODE) then
				if self.animationParts[5].clipEndTime then
					self:setAnimationTime(5, self.animationParts[5].offSet);
				else
					self:setAnimationTime(5, self.animationParts[5].animDuration);
				end;
			end;
		end;

		if InputBinding.hasEvent(InputBinding.Sipma_HUD_ON) then
			self.HUD = not self.HUD;
		end;
		if InputBinding.hasEvent(InputBinding.Sipma_RESET_BALECOUNTER) then
			self:resetBaleCounter(true);
		end;
	end;
	
	if self.isClient then
		if self.backOptionsNodeInRange then
			if InputBinding.hasEvent(InputBinding.Sipma_LOWER_PICKUP) then
				self:setBackFlap(not self.backFlap);
			end;
			if self.backFlap then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_BACK_FLAP_LIFT"), self.typeDesc), InputBinding.Sipma_LOWER_PICKUP);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_BACK_FLAP_LOWER"), self.typeDesc), InputBinding.Sipma_LOWER_PICKUP);
			end;
		end;
	end;
	
	if self.ropeDoorInRange then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:setRopePanel(not self.ropePanel);
		end;
		if not self.isLoaded then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setHasRopes(true);
			end;
		end;
		if self.ropePanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_OPEN_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_CLOSE_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
			if not self.isLoaded then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_RELOAD_ROPES"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;

	if self.NoRopesBalesCount >= self.ropesCapacity then
		self:setHasRopes(false);
	end;
end;

function Sipma:allowPickingUp(superFunc, area)
	return self.isTurnedOn and self.animationParts[4].clipEndTime and self.animationParts[6].clipEndTime;
end;

function Sipma:updateTick(dt)
	self.lastAreaBiggerZero = (self.lastfill ~= self.fillLevel);
	
	if self.attacherVehicle ~= nil then
		self:setAnimationTime(3, self.animationParts[3].animDuration);
	else
		self:setAnimationTime(3, self.animationParts[3].offSet);
	end;

	if --[[self.attacherVehicle and]] g_currentMission.player ~= nil then
		local nearestDistance = 1.5;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
				
		local sx, sy, sz = getWorldTranslation(self.backOptionsNode); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
		if distance < nearestDistance then
			self.backOptionsNodeInRange = true; 
		else
			self.backOptionsNodeInRange = false; 
		end;
		
		local tx, ty, tz = getWorldTranslation(self.ropeDoor); 
		local distance = Utils.vector3Length(tx-vx, ty-vy, tz-vz);	
		if distance < nearestDistance then
			self.ropeDoorInRange = true; 
		else
			self.ropeDoorInRange = false; 
		end;
	end;
	
	if self:getIsActive() then
		if self.animationParts[4].clipEndTime then
			rotate(self.pickupWheel, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
		end;
		if self.isTurnedOn then
			if self.CurrentBalesCount ~= 0 then
				if self.CurrentBalesCount % 2 == 0 then
					self:setAnimationTime(1, self.animationParts[1].startPosition);
				else
					self:setAnimationTime(1, self.animationParts[1].animDuration);
				end;
			end;
			
			if self:getIsActiveForSound() then		
				if self.time > self.soundOffset then
					if not self.balerSoundEnabled then
						playSample(self.balerSound, 0, self.balerSoundVolume, 0);
						self.balerSoundEnabled = true;
					end;
				else
					stopSample(self.balerSound);
					self.balerSoundEnabled = false;
				end;
			end;
		end;
	end;

	if self.backFlap == false then
		if self.moveBalesOutsideForTransport then
			self:setAnimationTime(6, self.animationParts[6].offSet);
		else
			self:moveBalesOutForTransport(dt, self);
		end;
	else
		self:setAnimationTime(6, self.animationParts[6].animDuration);
		self.moveBalesOutsideForTransport = false;
	end;
	
	if self.doResetBaleCounter then
		self.TotalBalesCount = 0;
		self.doResetBaleCounter = false;
	end;
	
	if self.isTurnedOn and not self:getIsActiveForSound() then
		if self.balerAISound ~= nil then
			setVisibility(self.balerAISound, true);
		end;
	else
		if self.balerAISound ~= nil then
			setVisibility(self.balerAISound, false);
		end;		
	end;
	
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn then
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 30;
			if not toFast then
				if not self:allowPickingUp() then
					for k, strawParticleSystem in pairs(self.strawParticleSystems) do
						Utils.setEmittingState(strawParticleSystem.particleSystem, false);
					end;
					for k, grassParticleSystem in pairs(self.grassParticleSystems) do
						Utils.setEmittingState(grassParticleSystem.particleSystem, false);
					end;
				end;
			end;
			
			if self.currentFillType == Fillable.FILLTYPE_GRASS_WINDROW or self.currentFillType == Fillable.FILLTYPE_DRYGRASS_WINDROW then
				for k, grassParticleSystem in pairs(self.grassParticleSystems) do
					Utils.setEmittingState(grassParticleSystem.particleSystem, self.lastAreaBiggerZero);
				end;
			else
				for k, strawParticleSystem in pairs(self.strawParticleSystems) do
					Utils.setEmittingState(strawParticleSystem.particleSystem, self.lastAreaBiggerZero);
				end;
			end;

			self.wasToFast = toFast;
		else
			for k, strawParticleSystem in pairs(self.strawParticleSystems) do
				Utils.setEmittingState(strawParticleSystem.particleSystem, false);
			end;
			for k, grassParticleSystem in pairs(self.grassParticleSystems) do
				Utils.setEmittingState(grassParticleSystem.particleSystem, false);
			end;
		end;
		
		local baleCountInBaler = table.getn(self.bales);
		if self.lastAreaBiggerZero and self.isTurnedOn and baleCountInBaler > 0 and self.baleStarNode ~= nil then
			rotate(self.baleStarNode, self.baleStarSpeed * self.lastSpeedReal * dt ,0,0);
		end;
		
		if self.isClient then
			if not self.isTurnedOn and self.balerSoundEnabled then
				stopSample(self.balerSound);
				self.balerSoundEnabled = false;
			end;
		end;

	end;
	
	if self.setAnimationTime ~= nil then
		if self.isTurnedOn then
			self:setAnimationTime(2, 1);
		else
			self:setAnimationTime(2, 0);
		end;
	end;

	if self.moveBalesOutside == false then
		self:moveBalesOut(dt, self);
	end;
	
	if self.doMoveBalesOutside then
		self:moveBalesOut(dt, self);
		self.doMoveBalesOutside = false;
	end;
	
	if table.getn(self.bales) > self.lastBaleCount then
		self.TotalBalesCount = self.TotalBalesCount + 1;
		self.NoRopesBalesCount = self.NoRopesBalesCount + 1;
		self.CurrentBalesCount = self.CurrentBalesCount + 1;
		self.lastBaleCount = self.lastBaleCount + 1;
	elseif table.getn(self.bales) < self.lastBaleCount then
		self.lastBaleCount = self.lastBaleCount - 1;
	end;
	
	if self.powerShaft.node ~= nil then
		if self.attacherVehicle ~= nil then
			setVisibility(self.powerShaft.node, true);
		else
			setVisibility(self.powerShaft.node, false);
		end;
	end;		
	
	self.lastfill = self.fillLevel;
end;

function Sipma:draw()
	if self.isClient then
		if self.isTurnedOn then
			g_currentMission:addExtraPrintText(g_i18n:getText("Sipma_TURNOFF_TO_SET_TRANSPORT_MODE"));
		else
			if self.animationParts[5].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_TRANSPORT_ON"), self.typeDesc), InputBinding.Sipma_WORK_MODE);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_TRANSPORT_OFF"), self.typeDesc), InputBinding.Sipma_WORK_MODE);
			end;
		end;
		
		if self.animationParts[4].clipEndTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_PICKUP_LIFT"), self.typeDesc), InputBinding.Sipma_LOWER_PICKUP);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_PICKUP_LOWER"), self.typeDesc), InputBinding.Sipma_LOWER_PICKUP);
		end;
			
		if self.animationParts[6].clipEndTime == false then
			g_currentMission:addExtraPrintText(g_i18n:getText("Sipma_LOWER_FLAP_TO_TURNON"));
		end;
		
		if self.HUD then
			self.HUDSipma:render();
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_HUD_OFF"), self.typeDesc), InputBinding.Sipma_HUD_ON);
			setTextBold(true);
			totalBalesCountString = string.format("%d", self.TotalBalesCount);
			renderText(0.72, 0.951, 0.02, string.format(totalBalesCountString));
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_HUD_ON"), self.typeDesc), InputBinding.Sipma_HUD_ON);	
		end;
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Sipma_RESET_COUNTER"), self.typeDesc), InputBinding.Sipma_RESET_BALECOUNTER);	
		if not self.isLoaded then
			g_currentMission:addWarning(g_i18n:getText("Sipma_NOROPE") .. "\n" .. g_i18n:getText("Sipma_NOROPE_WARNING"), 0.07+0.022, 0.019+0.029);	
		end;		
	end;
end;

function Sipma:onDetach()
	if self.deactivateOnDetach then
		Sipma.onDeactivate(self);
	else
		Sipma.onDeactivateSounds(self);
	end;
	
	for k, strawParticleSystem in pairs(self.strawParticleSystems) do
		Utils.setEmittingState(strawParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
	if self.balerStartSound ~= nil then
		stopSample(self.balerStartSound);
	end;
	if self.balerStopSound ~= nil then
		stopSample(self.balerStopSound);
	end;
end;

function Sipma:onLeave()
	if self.deactivateOnLeave then
		Sipma.onDeactivate(self);
	else
		Sipma.onDeactivateSounds(self);
	end;

	for k, strawParticleSystem in pairs(self.strawParticleSystems) do
		Utils.setEmittingState(strawParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
end;

function Sipma:onDeactivate()
	self.wasToFast = false;
	Sipma.onDeactivateSounds(self)
	
	for k, strawParticleSystem in pairs(self.strawParticleSystems) do
		Utils.setEmittingState(strawParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
end;

function Sipma:onDeactivateSounds()
	if self.balerSoundEnabled then
		stopSample(self.balerSound);
		self.balerSoundEnabled = false;
	end;
end;

function Sipma:setIsTurnedOn(isTurnedOn, noEventSend)
	local soundOffset = 0;
	if not isTurnedOn then
		if self.balerAISound ~= nil then
			setVisibility(self.balerAISound, false);
		end;
		self.animationEnabled = true;
		if self:getIsActive() then
			if self:getIsActiveForSound() then	
				if self.time < self.soundOffset then
					stopSample(self.balerStartSound);
				else
					if self.balerStopSound ~= nil then
						playSample(self.balerStopSound, 1, self.balerStopSoundVolume, 0);
						soundOffset = getSampleDuration(self.balerStopSound);
					end;
				end;
			end;
		end;
	else
		if self:getIsActive() then
			if self:getIsActiveForSound() then					
				self.balerSoundEnabled = false;
				stopSample(self.balerSound);
				
				if self.time < self.soundOffset then
					stopSample(self.balerStopSound);
				end;
				playSample(self.balerStartSound, 1, self.balerStartSoundVolume, 0);
				soundOffset = getSampleDuration(self.balerStartSound);		
			end;
		end;
	end;
	self.soundOffset = self.time + soundOffset;
end;

function Sipma:moveBalesOutForTransport(dt, self)
	local done = true;
	for k, bale in pairs(self.bales) do
		if bale.time > 0.5 then
			local sendTime = math.min(1, bale.time+dt/5000);
			self.setBaleTime(self, k, sendTime, true);
			done = false;
		end;
	end;
	self.moveBalesOutsideForTransport = done;
	return;
end;

function Sipma:setBackFlap(isBackFlap,noEventSend)
	SetBackFlapEvent.sendEvent(self, isBackFlap, noEventSend);
	self.backFlap = isBackFlap;
	if self.backFlap == false then
		self:setIsTurnedOn(false);
	end;
end;

function Sipma:resetBaleCounter(doBalebaleCounter,noEventSend)
	ResetBaleCounterEvent.sendEvent(self, resetBaleCounter, noEventSend);
	self.doResetBaleCounter = doBalebaleCounter;	
end;

function Sipma:setRopePanel(isRopePanel,noEventSend)
	SetRopePanelEvent.sendEvent(self, isRopePanel, noEventSend);
	if isRopePanel then
		if self.ropePanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ropePanelAnimation, -1, nil, true);
			self.ropePanel = true;
		end;
	else
		if self.ropePanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ropePanelAnimation, 1, nil, true);
			self.ropePanel = false;
		end;
	end;
end;

function Sipma:setHasRopes(isLoaded,noEventSend)
	self.isLoaded = isLoaded;
	SetHasRopesEvent.sendEvent(self, self.isLoaded, noEventSend);
	if self.isLoaded then
		self.NoRopesBalesCount = 0;
		setVisibility(self.ropes, true);
		if self.NoRopePlaying then
			stopSample(self.NoRopeSoundId);
			self.NoRopePlaying = false;
		end;
	else
		setVisibility(self.ropes, false);	
		self:setIsTurnedOn(false);
		if self:getIsActiveForSound() then
			if not self.NoRopePlaying then
				playSample(self.NoRopeSoundId, 1, 1, 0);
				self.NoRopePlaying = true;
			end;
		end;
	end;
end;

function Sipma:moveBalesOut(dt, self)
	local done = true;
	for k, bale in pairs(self.bales) do
		if bale.time > 0.15 then
			local sendTime = math.min(1, bale.time+dt/5000);
			self.setBaleTime(self, k, sendTime, true);
			done = false;
		end;
	end;
	self.moveBalesOutside = done;
	return;
end;

function Sipma:doMoveBalesOut(moveBales, noEventSend)
	MoveBalesOutEvent.sendEvent(self, moveBales, noEventSend);
	self.doMoveBalesOutside = moveBales;
end;