--edit hummel (modhoster.de)
moveTowball = {};

function moveTowball.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveTowball:load(xmlFile)
	self.setyAttacherI= SpecializationUtil.callSpecializationsFunction("setyAttacherI");
	self.moveableTowball = {};
	self.moveableTowball.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableTowball#index"));
	self.moveableTowball.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableTowball#maxY"), 0); 
	self.moveableTowball.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableTowball#minY"), 0); 
	
	if self.moveableTowball ~= nil then
	
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableTowball.index);
		self.yAttacher = yAttacher
	end
	
end;

function moveTowball:delete()
end;

function moveTowball:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveTowball:keyEvent(unicode, sym, modifier, isDown)

end;

function moveTowball:update(dt)

	if self.moveableTowball ~= nil then
	
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableTowball.index);
		local maxY = self.moveableTowball.max;
		local minY = self.moveableTowball.min;
		local moveSpeed = 0.004;
		
			if InputBinding.isPressed(InputBinding.ATTACHERTowball_UP) and self:getIsActiveForInput() then
					
				if self.yAttacher < maxY then
					self.yAttacher = yAttacher + moveSpeed;
				else
					self.yAttacher = maxY;
				end;
				   self:setyAttacherI(self.yAttacher);
			elseif InputBinding.isPressed(InputBinding.ATTACHERTowball_DOWN) and self:getIsActiveForInput() then
				if self.yAttacher > minY then
					self.yAttacher = yAttacher - moveSpeed;
				else
					self.yAttacher = minY;
				end;
				   self:setyAttacherI(self.yAttacher);
			end;
	end;
				
end;

function moveTowball:setyAttacherI(value, noEventSend)
  local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableTowball.index);
  moveTowballEvent.sendEvent(self, value, noEventSend);
  self.yAttacher = value
  
  setTranslation(self.moveableTowball.index, xAttacher, self.yAttacher, zAttacher);
  
end

function moveTowball:readStream(streamId, connection)


	self.yAttacher = streamReadFloat32(streamId);	

end;

function moveTowball:writeStream(streamId, connection)

	streamWriteFloat32(streamId, self.yAttacher);

end;


function moveTowball:onLeave()
	moveTowballEvent.sendEvent(self, self.yAttacher);
end;

function moveTowball:draw()
	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("ATTACHER_TOWBALL"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ATTACHERTowball_UP) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ATTACHERTowball_DOWN));

end;

function moveTowball:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

moveTowballEvent = {};
moveTowballEvent_mt = Class(moveTowballEvent, Event);

InitEventClass(moveTowballEvent, "moveTowballEvent");

function moveTowballEvent:emptyNew()
    local self = Event:new(moveTowballEvent_mt);
    self.className="moveTowballEvent";
    return self;
end;

function moveTowballEvent:new(object, data)
    local self = moveTowballEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function moveTowballEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);	
	self.data = streamReadFloat32(streamId);
	self:run(connection);
end;

function moveTowballEvent:run(connection)
    self.object:setyAttacherI(self.data , true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(moveTowballEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function moveTowballEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.data);
end;

              
function moveTowballEvent.sendEvent(vehicle, data, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(moveTowballEvent:new(vehicle, data), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(moveTowballEvent:new(vehicle, data));
		end;
	end
end;



