--
-- SampleModMap
--
-- @author  juangb
-- @date  11/11/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ExtreNort2013 = {}

local ExtreNort2013_mt = Class(ExtreNort2013, Mission00);


function ExtreNort2013:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = ExtreNort2013_mt;
    end;
    local self = ExtreNort2013:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function ExtreNort2013:delete()
    ExtreNort2013:superClass().delete(self);
end;

function ExtreNort2013:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/ExtreNort2013.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function ExtreNort2013:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("ExtreNort2013.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

   

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 1024 - 130, 1024 - 383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

  

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 43.5, 1024 - 128.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 + 395.1, 1024 - 693.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 888.8 , 1024 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 1024 + 256, 1024 + 655, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 1024 - 600, 1024 + 585, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 1024 - 12, 1024 - 93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    ExtreNort2013:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function ExtreNort2013:onStartMission()
    ExtreNort2013:superClass().onStartMission(self);
end;

function ExtreNort2013:mouseEvent(posX, posY, isDown, isUp, button)
    ExtreNort2013:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function ExtreNort2013:keyEvent(unicode, sym, modifier, isDown)
    ExtreNort2013:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function ExtreNort2013:update(dt)
    ExtreNort2013:superClass().update(self, dt);
end;

function ExtreNort2013:draw()
    ExtreNort2013:superClass().draw(self);
end;