--
-- Addon for moveable Farmerarm
--
-- @author Aranea
-- @date 01/02/2013
--
-- Bugfix for 2nd tractor when resetting position by RivalBomb

FarmerArm = {};

function FarmerArm.prerequisitesPresent(specializations)
	return true;
end;

function FarmerArm:load(xmlFile)
	self.armNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#armIndex"));
	if self.armNode ~= nil then
		setVisibility(self.armNode, false);
	end;
end;

function FarmerArm:delete()
end;

function FarmerArm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FarmerArm:keyEvent(unicode, sym, modifier, isDown)
end;

function FarmerArm:update(dt)
end;

function FarmerArm:updateTick(dt)
end;

function FarmerArm:draw()
end;

function FarmerArm:onEnter()
	if self.armNode ~= nil then
		setVisibility(self.armNode, true);
	end;
end;

function FarmerArm:onLeave()
	if self.armNode ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.armNode, false);
		else
			setVisibility(self.armNode, true);
		end;
	end;
end;
