--
-- Skaliert die Unterlenker passend, sodass die Standartmige Z-Translation fr die Bodenanpassung an den Unterlenkern weniger auffllt
-- Scales the BottomArm to hide the z-Translation
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net

unterlenkerScale = {};

function unterlenkerScale.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function unterlenkerScale:load(xmlFile)
	self.uS = {}; -- unterlenkerScale (BottomArm Scaling)
	self.uS.scaleIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UnterlenkerScale#scaleIndex"));
	self.uS.scaleRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UnterlenkerScale#scaleRef"));
	self.uS.scaleRef2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UnterlenkerScale#scaleRef2"));
	self.uS.doUpdateTickScale = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.UnterlenkerScale#doUpdateTickScale"),false);
	
	local dax, day, daz = getWorldTranslation(self.uS.scaleIndex);
    local dbx, dby, dbz = getWorldTranslation(self.uS.scaleRef2);
    self.uS.scaleDistance = Utils.vector3Length(dax-dbx, day-dby, daz-dbz);
	
	self.hasImplementAttached = false;
end;
function unterlenkerScale:update(dt)
	if self.uS.doUpdateTickScale == false then
		if self:getIsActive() then
			if self.hasImplementAttached == true then -- Berechnung wird nur ausgefhrt wenn Implement an Attacher Nr.1 hngt. Sodass das ganze nicht unntig andauernd berechnet wird..
				if self.uS.scaleIndex ~= nil and self.uS.scaleRef ~= nil and self.uS.scaleRef2 ~= nil then
					local ax, ay, az = getWorldTranslation(self.uS.scaleIndex);
					local bx, by, bz = getWorldTranslation(self.uS.scaleRef);
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					local dax, day, daz = getWorldTranslation(self.uS.scaleIndex);
					local dbx, dby, dbz = getWorldTranslation(self.uS.scaleRef2);
					self.uS.scaleDistance = Utils.vector3Length(dax-dbx, day-dby, daz-dbz);				
					local scaleX, scaleY, scaleZ = getScale(self.uS.scaleIndex);
					local setScaleWert = scaleZ * (distance / self.uS.scaleDistance);
					setScale(self.uS.scaleIndex, 1, 1, setScaleWert);
				end;
			end;
		end;
	end;
end;
function unterlenkerScale:updateTick(dt)
	if self.uS.doUpdateTickScale == true then
		if self:getIsActive() then
			if self.hasImplementAttached == true then -- Berechnung wird nur ausgefhrt wenn Implement an Attacher Nr.1 hngt. Sodass das ganze nicht unntig andauernd berechnet wird..
				if self.uS.scaleIndex ~= nil and self.uS.scaleRef ~= nil and self.uS.scaleRef2 ~= nil then
					local ax, ay, az = getWorldTranslation(self.uS.scaleIndex);
					local bx, by, bz = getWorldTranslation(self.uS.scaleRef);
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					local dax, day, daz = getWorldTranslation(self.uS.scaleIndex);
					local dbx, dby, dbz = getWorldTranslation(self.uS.scaleRef2);
					self.uS.scaleDistance = Utils.vector3Length(dax-dbx, day-dby, daz-dbz);				
					local scaleX, scaleY, scaleZ = getScale(self.uS.scaleIndex);
					local setScaleWert = scaleZ * (distance / self.uS.scaleDistance);
					setScale(self.uS.scaleIndex, 1, 1, setScaleWert);
				end;
			end;
		end;
	end;
end;
function unterlenkerScale:attachImplement(implement)
	local attacherIndex = implement.jointDescIndex;
	if attacherIndex == 1 then
		self.hasImplementAttached = true;
	end;
end;
function unterlenkerScale:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local attacherIndex = implement.jointDescIndex;
    if attacherIndex == 1 then
		self.hasImplementAttached = false;
	end;
end;
function unterlenkerScale:draw()
end;
function unterlenkerScale:delete()
end;
function unterlenkerScale:mouseEvent(posX, posY, isDown, isUp, button)
end;
function unterlenkerScale:keyEvent(unicode, sym, modifier, isDown)
end;