-- by modelleicher
-- http://schwabenmodding.bplaced.net
-- geschrieben fr den Eicher EA 400 Traktometer

animatedDetails = {};

function animatedDetails.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function animatedDetails:load(xmlFile)
    -- Tachozeiger --
	self.tachoZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animatedDetails.tachoZeiger#zeigerIndex"));
	self.tachoZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedDetails.tachoZeiger#multiplicator"), 10);
	self.tachoZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedDetails.tachoZeiger#maxRotation"), 245);
	
	-- Gaspedal --
	self.gasPedal = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animatedDetails.gasPedal#pedalIndex"));
	self.gasPedalMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedDetails.gasPedal#multiplicator"), 0.5);
	self.gasPedalMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedDetails.gasPedal#maxRotation"), 12);
	
	-- Tankwarnleuchte --
	self.tankWarnLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animatedDetails.tankWarnLeuchte#index"));
	self.tankWarnMenge = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedDetails.tankWarnLeuchte#warnValue"), 20);
end;

function animatedDetails:delete()
end;
function animatedDetails:mouseEvent(posX, posY, isDown, isUp, button)
end;
function animatedDetails:keyEvent(unicode, sym, modifier, isDown)
end;
function animatedDetails:update(dt)
	if self:getIsActive() then
		-- Tachozeiger und Gaspedal --
		if self.isMotorStarted then
			self.kmhMath = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local zeigerRotation = self.kmhMath * self.tachoZeigerMultiplicator;
			if zeigerRotation <= self.tachoZeigerMaxRotation then
				setRotation(self.tachoZeiger, 0, 0, Utils.degToRad(zeigerRotation));
			else
				setRotation(self.tachoZeiger, 0, 0, Utils.degToRad(self.tachoZeigerMaxRotation));	
			end;
			local gasPedalRotation = self.kmhMath * self.gasPedalMultiplicator
			if gasPedalRotation <= self.gasPedalMaxRot then
				setRotation(self.gasPedal, Utils.degToRad(gasPedalRotation), 0, 0);
			else
				setRotation(self.gasPedal, Utils.degToRad(self.gasPedalMaxRot), 0, 0);
			end;
		else
			setRotation(self.tachoZeiger, 0, 0, 0);
		end;
		
		-- Tankwarnleuchte --
		local actualTankInhalt = 0;
		if self.fuelCapacity > 0 then
			actualTankInhalt = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
		end;
		if actualTankInhalt < self.tankWarnMenge then
			setVisibility(self.tankWarnLeuchte, true);
		else
			setVisibility(self.tankWarnLeuchte, false);
		end;

	else
		-- Tankwarnleichte --
		setVisibility(self.tankWarnLeuchte, false);
	end;
end;

function animatedDetails:updateTick(dt)
end;
function animatedDetails:draw()
end;

