-- Autor: xXx (Ziut)
-- 
--
SpecializationUtil.registerSpecialization("ESLimiter", "ESLimiter", g_currentModDirectory .. "ESLimiter.lua")

function add_ESLimiter()
	for _, v in pairs(VehicleTypeUtil.vehicleTypes) do  
		if v ~= nil then
			for i = 1, table.maxn(v.specializations) do
				local vs = v.specializations[i];
				if vs ~= nil and vs == SpecializationUtil.getSpecialization("motorized") then
					if not SpecializationUtil.hasSpecialization(ESLimiter, v.specializations) then
						table.insert(v.specializations, SpecializationUtil.getSpecialization("ESLimiter"));
					end
					
					vs.ESLIMIT_DISABLED = g_i18n:getText("ESLIMIT_DISABLED");
					vs.ESLIMIT_LEVEL = g_i18n:getText("ESLIMIT_LEVEL");
					vs.ESLIMIT_CONTROLS = g_i18n:getText("ESLIMIT_CONTROLS");
					vs.ESLIMIT_INCREASE = g_i18n:getText("ESLIMIT_INCREASE");
					vs.ESLIMIT_DECREASE = g_i18n:getText("ESLIMIT_DECREASE");
					
					vs.ESLimiter_hud = Overlay:new("ESLimiter_hud", Utils.getFilename("ESLimiter_hud.dds", g_currentModDirectory), 0.7543, 0.2350, 0.2371, 0.039525);
				end;
			end;
		end;
	end;
end;
add_ESLimiter();