--
-- priborka
-- author: werik
--

priborka = {};

function priborka.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function priborka:load(xmlFile)

-- spidometr

local rotationPartNodeKmh1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;

-- toplivo

local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;

    fuelwarningSoundFile = Utils.getFilename("fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	self.playedSound = false;
	self.ledriserva = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.riserva = 20;

-- manometr break

 local rotationPartNodemanometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr#index"));
    if rotationPartNodemanometr ~= nil then
        self.rotationPartmanometr = {};
        self.rotationPartmanometr.node = rotationPartNodemanometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr#minRot"));
        self.rotationPartmanometr.minRot = {};
        self.rotationPartmanometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr#maxRot"));
        self.rotationPartmanometr.maxRot = {};
        self.rotationPartmanometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr#rotTime"), 2)*1000;
        self.rotationPartmanometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr0 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr0#index"));
    if rotationPartNodemanometr0 ~= nil then
        self.rotationPartmanometr0 = {};
        self.rotationPartmanometr0.node = rotationPartNodemanometr0;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr0#minRot"));
        self.rotationPartmanometr0.minRot = {};
        self.rotationPartmanometr0.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr0.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr0.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr0#maxRot"));
        self.rotationPartmanometr0.maxRot = {};
        self.rotationPartmanometr0.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr0.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr0.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr0.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr0#rotTime"), 2)*1000;
        self.rotationPartmanometr0.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr0#touchRotLimit"), 10));
    end;

-- voda

local rotationPartNodevoda1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda1#index"));
    if rotationPartNodevoda1 ~= nil then
        self.rotationPartvoda1 = {};
        self.rotationPartvoda1.node = rotationPartNodevoda1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#minRot"));
        self.rotationPartvoda1.minRot = {};
        self.rotationPartvoda1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#maxRot"));
        self.rotationPartvoda1.maxRot = {};
        self.rotationPartvoda1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#rotTime"), 2)*1000;
        self.rotationPartvoda1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#touchRotLimit"), 10));
    end;
local rotationPartNodevoda2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda2#index"));
    if rotationPartNodevoda2 ~= nil then
        self.rotationPartvoda2 = {};
        self.rotationPartvoda2.node = rotationPartNodevoda2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#minRot"));
        self.rotationPartvoda2.minRot = {};
        self.rotationPartvoda2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#maxRot"));
        self.rotationPartvoda2.maxRot = {};
        self.rotationPartvoda2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#rotTime"), 2)*1000;
        self.rotationPartvoda2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#touchRotLimit"), 10));
    end;
local rotationPartNodevoda3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda3#index"));
    if rotationPartNodevoda3 ~= nil then
        self.rotationPartvoda3 = {};
        self.rotationPartvoda3.node = rotationPartNodevoda3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#minRot"));
        self.rotationPartvoda3.minRot = {};
        self.rotationPartvoda3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#maxRot"));
        self.rotationPartvoda3.maxRot = {};
        self.rotationPartvoda3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#rotTime"), 2)*1000;
        self.rotationPartvoda3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#touchRotLimit"), 10));
    end;
local rotationPartNodevoda4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda4#index"));
    if rotationPartNodevoda4 ~= nil then
        self.rotationPartvoda4 = {};
        self.rotationPartvoda4.node = rotationPartNodevoda4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#minRot"));
        self.rotationPartvoda4.minRot = {};
        self.rotationPartvoda4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#maxRot"));
        self.rotationPartvoda4.maxRot = {};
        self.rotationPartvoda4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#rotTime"), 2)*1000;
        self.rotationPartvoda4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#touchRotLimit"), 10));
    end;
local rotationPartNodevoda5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda5#index"));
    if rotationPartNodevoda5 ~= nil then
        self.rotationPartvoda5 = {};
        self.rotationPartvoda5.node = rotationPartNodevoda5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda5#minRot"));
        self.rotationPartvoda5.minRot = {};
        self.rotationPartvoda5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda5#maxRot"));
        self.rotationPartvoda5.maxRot = {};
        self.rotationPartvoda5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda5#rotTime"), 2)*1000;
        self.rotationPartvoda5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda5#touchRotLimit"), 10));
    end;
local rotationPartNodevoda6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda6#index"));
    if rotationPartNodevoda6 ~= nil then
        self.rotationPartvoda6 = {};
        self.rotationPartvoda6.node = rotationPartNodevoda6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda6#minRot"));
        self.rotationPartvoda6.minRot = {};
        self.rotationPartvoda6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda6#maxRot"));
        self.rotationPartvoda6.maxRot = {};
        self.rotationPartvoda6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda6#rotTime"), 2)*1000;
        self.rotationPartvoda6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda6#touchRotLimit"), 10));
    end;
local rotationPartNodevoda7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda7#index"));
    if rotationPartNodevoda7 ~= nil then
        self.rotationPartvoda7 = {};
        self.rotationPartvoda7.node = rotationPartNodevoda7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda7#minRot"));
        self.rotationPartvoda7.minRot = {};
        self.rotationPartvoda7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda7#maxRot"));
        self.rotationPartvoda7.maxRot = {};
        self.rotationPartvoda7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda7#rotTime"), 2)*1000;
        self.rotationPartvoda7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda7#touchRotLimit"), 10));
    end;
local rotationPartNodevoda8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda8#index"));
    if rotationPartNodevoda8 ~= nil then
        self.rotationPartvoda8 = {};
        self.rotationPartvoda8.node = rotationPartNodevoda8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda8#minRot"));
        self.rotationPartvoda8.minRot = {};
        self.rotationPartvoda8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda8#maxRot"));
        self.rotationPartvoda8.maxRot = {};
        self.rotationPartvoda8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda8#rotTime"), 2)*1000;
        self.rotationPartvoda8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda8#touchRotLimit"), 10));
    end;

-- tahometr

local rotationPartNodetahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tahometr#index"));
    if rotationPartNodetahometr ~= nil then
        self.rotationParttahometr = {};
        self.rotationParttahometr.node = rotationPartNodetahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#minRot"));
        self.rotationParttahometr.minRot = {};
        self.rotationParttahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#maxRot"));
        self.rotationParttahometr.maxRot = {};
        self.rotationParttahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr#rotTime"), 2)*1000;
        self.rotationParttahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr#touchRotLimit"), 10));
    end;

--ampermetr

local rotationPartNodeamper1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper1#index"));
    if rotationPartNodeamper1 ~= nil then
        self.rotationPartamper1 = {};
        self.rotationPartamper1.node = rotationPartNodeamper1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper1#minRot"));
        self.rotationPartamper1.minRot = {};
        self.rotationPartamper1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper1#maxRot"));
        self.rotationPartamper1.maxRot = {};
        self.rotationPartamper1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper1#rotTime"), 2)*1000;
        self.rotationPartamper1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper1#touchRotLimit"), 10));
    end;
local rotationPartNodeamper2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper2#index"));
    if rotationPartNodeamper2 ~= nil then
        self.rotationPartamper2 = {};
        self.rotationPartamper2.node = rotationPartNodeamper2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper2#minRot"));
        self.rotationPartamper2.minRot = {};
        self.rotationPartamper2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper2#maxRot"));
        self.rotationPartamper2.maxRot = {};
        self.rotationPartamper2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper2#rotTime"), 2)*1000;
        self.rotationPartamper2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper2#touchRotLimit"), 10));
    end;
local rotationPartNodeamper3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper3#index"));
    if rotationPartNodeamper3 ~= nil then
        self.rotationPartamper3 = {};
        self.rotationPartamper3.node = rotationPartNodeamper3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper3#minRot"));
        self.rotationPartamper3.minRot = {};
        self.rotationPartamper3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper3#maxRot"));
        self.rotationPartamper3.maxRot = {};
        self.rotationPartamper3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper3#rotTime"), 2)*1000;
        self.rotationPartamper3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper3#touchRotLimit"), 10));
    end;
local rotationPartNodeamper4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper4#index"));
    if rotationPartNodeamper4 ~= nil then
        self.rotationPartamper4 = {};
        self.rotationPartamper4.node = rotationPartNodeamper4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper4#minRot"));
        self.rotationPartamper4.minRot = {};
        self.rotationPartamper4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper4#maxRot"));
        self.rotationPartamper4.maxRot = {};
        self.rotationPartamper4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper4#rotTime"), 2)*1000;
        self.rotationPartamper4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper4#touchRotLimit"), 10));
    end;
local rotationPartNodeamper5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper5#index"));
    if rotationPartNodeamper5 ~= nil then
        self.rotationPartamper5 = {};
        self.rotationPartamper5.node = rotationPartNodeamper5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper5#minRot"));
        self.rotationPartamper5.minRot = {};
        self.rotationPartamper5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper5#maxRot"));
        self.rotationPartamper5.maxRot = {};
        self.rotationPartamper5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper5#rotTime"), 2)*1000;
        self.rotationPartamper5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper5#touchRotLimit"), 10));
    end;
local rotationPartNodeamper6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper6#index"));
    if rotationPartNodeamper6 ~= nil then
        self.rotationPartamper6 = {};
        self.rotationPartamper6.node = rotationPartNodeamper6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper6#minRot"));
        self.rotationPartamper6.minRot = {};
        self.rotationPartamper6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper6#maxRot"));
        self.rotationPartamper6.maxRot = {};
        self.rotationPartamper6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper6#rotTime"), 2)*1000;
        self.rotationPartamper6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper6#touchRotLimit"), 10));
    end;
end;

function priborka:readStream(streamId, connection)
end;

function priborka:writeStream(streamId, connection)
end;

function priborka:delete()
end;

 
function priborka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function priborka:keyEvent(unicode, sym, modifier, isDown)

end;
 
function priborka:update(dt)

--other to motor started

if self.isMotorStarted then
self.rotationMaxvoda1 = true;
self.rotationMaxvoda2 = false;
self.rotationMaxvoda3 = true;
self.rotationMaxvoda4 = false;
self.rotationMaxvoda5 = true;
self.rotationMaxvoda6 = false;
self.rotationMaxvoda7 = true;
self.rotationMaxvoda8 = false;
self.rotationMaxamper1 = true;
self.rotationMaxamper2 = true;
self.rotationMaxamper3 = true;
self.rotationMaxamper4 = false;
self.rotationMaxamper5 = false;
self.rotationMaxamper6 = false;
         else
self.rotationMaxvoda1 = false;
self.rotationMaxvoda2 = true;
self.rotationMaxvoda3 = false;
self.rotationMaxvoda4 = true;
self.rotationMaxvoda5 = false;
self.rotationMaxvoda6 = true;
self.rotationMaxvoda7 = false;
self.rotationMaxvoda8 = true;
self.rotationMaxamper1 = false;
self.rotationMaxamper2 = false;
self.rotationMaxamper3 = false;
self.rotationMaxamper4 = true;
self.rotationMaxamper5 = true;
self.rotationMaxamper6 = true;
              end;
	
-- spidometr

local maxKmh = 50;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;

-- toplivo

if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;

	if self.isEntered then
		if self.fuelFillLevel < 20 then
			self.riserva = self.riserva - dt;
			if self.playedSound == false then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.playedSound = true;
			end;
			self.ledriservaActive = true;
		else
			self.playedSound = false;
			self.ledriservaActive = false;
		    end;
		     setVisibility(self.ledriserva, self.ledriservaActive);
       end;

-- manometr break

if self.brakeLightsVisibility then
self.rotationMaxmanometr = true;
self.rotationMaxmanometr0 = false;
         else
self.rotationMaxmanometr0 = true;
self.rotationMaxmanometr = false;
	end;

if self.rotationMaxmanometr == true then
if self.rotationPartmanometr ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr.maxRot, self.rotationPartmanometr.minRot, 3, self.rotationPartmanometr.rotTime, dt, not self.rotationMaxmanometr);
		   setRotation(self.rotationPartmanometr.node, unpack(newRot));
       end;
    end;

if self.rotationMaxmanometr0 == true then
if self.rotationPartmanometr0 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr0.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr0.maxRot, self.rotationPartmanometr0.minRot, 3, self.rotationPartmanometr0.rotTime, dt, not self.rotationMaxmanometr0);
		   setRotation(self.rotationPartmanometr0.node, unpack(newRot));
       end;
   end;

-- voda

if self.rotationMaxvoda1 == true then
if self.rotationPartvoda1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda1.maxRot, self.rotationPartvoda1.minRot, 3, self.rotationPartvoda1.rotTime, dt, not self.rotationMaxvoda1);
		   setRotation(self.rotationPartvoda1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda2 == true then
if self.rotationPartvoda2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda2.maxRot, self.rotationPartvoda2.minRot, 3, self.rotationPartvoda2.rotTime, dt, not self.rotationMaxvoda2);
		   setRotation(self.rotationPartvoda2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda3 == true then
if self.rotationPartvoda3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda3.maxRot, self.rotationPartvoda3.minRot, 3, self.rotationPartvoda3.rotTime, dt, not self.rotationMaxvoda3);
		   setRotation(self.rotationPartvoda3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda4 == true then
if self.rotationPartvoda4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda4.maxRot, self.rotationPartvoda4.minRot, 3, self.rotationPartvoda4.rotTime, dt, not self.rotationMaxvoda4);
		   setRotation(self.rotationPartvoda4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda5 == true then
if self.rotationPartvoda5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda5.maxRot, self.rotationPartvoda5.minRot, 3, self.rotationPartvoda5.rotTime, dt, not self.rotationMaxvoda5);
		   setRotation(self.rotationPartvoda5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda6 == true then
if self.rotationPartvoda6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda6.maxRot, self.rotationPartvoda6.minRot, 3, self.rotationPartvoda6.rotTime, dt, not self.rotationMaxvoda6);
		   setRotation(self.rotationPartvoda6.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda7 == true then
if self.rotationPartvoda7 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda7.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda7.maxRot, self.rotationPartvoda7.minRot, 3, self.rotationPartvoda7.rotTime, dt, not self.rotationMaxvoda7);
		   setRotation(self.rotationPartvoda7.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda8 == true then
if self.rotationPartvoda8 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda8.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda8.maxRot, self.rotationPartvoda8.minRot, 3, self.rotationPartvoda8.rotTime, dt, not self.rotationMaxvoda8);
		   setRotation(self.rotationPartvoda8.node, unpack(newRot));
       end;
   end;

-- tahometr

local maxtahometr = 2000;
	if self.rotationParttahometr ~= nil then
		local x, y, z = getRotation(self.rotationParttahometr.node);
		y = ((self.rotationParttahometr.maxRot[2] - self.rotationParttahometr.minRot[2]) / maxtahometr) * self.motor.lastMotorRpm + self.rotationParttahometr.minRot[2];
		setRotation(self.rotationParttahometr.node, x, y ,z);
	end;

-- ampermetr

if self.rotationMaxamper1 == true then
if self.rotationPartamper1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper1.maxRot, self.rotationPartamper1.minRot, 3, self.rotationPartamper1.rotTime, dt, not self.rotationMaxamper1);
		   setRotation(self.rotationPartamper1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper2 == true then
if self.rotationPartamper2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper2.maxRot, self.rotationPartamper2.minRot, 3, self.rotationPartamper2.rotTime, dt, not self.rotationMaxamper2);
		   setRotation(self.rotationPartamper2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper3 == true then
if self.rotationPartamper3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper3.maxRot, self.rotationPartamper3.minRot, 3, self.rotationPartamper3.rotTime, dt, not self.rotationMaxamper3);
		   setRotation(self.rotationPartamper3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper4 == true then
if self.rotationPartamper4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper4.maxRot, self.rotationPartamper4.minRot, 3, self.rotationPartamper4.rotTime, dt, not self.rotationMaxamper4);
		   setRotation(self.rotationPartamper4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper5 == true then
if self.rotationPartamper5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper5.maxRot, self.rotationPartamper5.minRot, 3, self.rotationPartamper5.rotTime, dt, not self.rotationMaxamper5);
		   setRotation(self.rotationPartamper5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper6 == true then
if self.rotationPartamper6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper6.maxRot, self.rotationPartamper6.minRot, 3, self.rotationPartamper6.rotTime, dt, not self.rotationMaxamper6);
		   setRotation(self.rotationPartamper6.node, unpack(newRot));
       end;
   end;
end;	

function priborka:onLeave()
end;

function priborka:draw()
end;
