-- ELHOMaster220
-- 
-- ELHO Master 220 specialization
--
-- @author  JoXXer
-- @date  	09/08/13

ELHOMaster220 = {};

function ELHOMaster220.prerequisitesPresent(specializations)
    return true;
end;

function ELHOMaster220:load(xmlFile)
	self.warningTime = 0;
	self.warningText = "";
end;

function ELHOMaster220:delete()
end;

function ELHOMaster220:readStream(streamId, connection)
end;

function ELHOMaster220:writeStream(streamId, connection)
end;

function ELHOMaster220:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ELHOMaster220:keyEvent(unicode, sym, modifier, isDown)
end;

function ELHOMaster220:update(dt)
end;

function ELHOMaster220:updateTick(dt)
	local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
	
	if not self.attachablePTO.attached then
		if self.isTurnedOn then
			self.warningTime = self.time + 1500;
			self.warningText = string.format(g_i18n:getText("ATTACH_PTO_WARNING"), self.typeDesc);
		end;
		self:setIsTurnedOn(false);
	end;
	
	if not self.attachablePTO.attached and toFast then
		self.warningTime = self.time + 1500;
		self.warningText = string.format(g_i18n:getText("ATTACH_PTO_WARNING_SPEED"), self.typeDesc);
	end;
end;

function ELHOMaster220:onAttach(attacherVehicle)
end;

function ELHOMaster220:onDetach()
end;

function ELHOMaster220:draw()
	if self.warningTime > self.time then
		g_currentMission:addWarning(self.warningText, 0.018, 0.033);
	end;
end;