--
-- Specialization for small polish trailer
-- Adam 334, 23/06/2014
-- 

SmallTrailer = {};

function SmallTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function SmallTrailer:load(xmlFile)
	self.setDoorAnimation = SmallTrailer.setDoorAnimation;
	self.Animation = getXMLString(xmlFile, "vehicle.Animation#name");
	self.AnimationSpeed = getXMLFloat(xmlFile, "vehicle.Animation#speed");
	self.referencesObject = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Animation#refIndex"));
	self.isAnimationPlayed = false;
	self.inRange = false;
	--# From StrawMod by burner
	
	local seedBagsIndex = getXMLString(xmlFile, "vehicle.seedBags#index");
    self.seedBagsCount = getXMLInt(xmlFile, "vehicle.seedBags#count");
    self.seedBagsRootNode = Utils.indexToObject(self.components, seedBagsIndex);
	
	local fertilizerBagsIndex = getXMLString(xmlFile, "vehicle.fertilizerBags#index");
    self.fertilizerBagsCount = getXMLInt(xmlFile, "vehicle.fertilizerBags#count");
    self.fertilizerBagsRootNode = Utils.indexToObject(self.components, fertilizerBagsIndex);
	
	local pigsIndex = getXMLString(xmlFile, "vehicle.Pigs#index");
    self.pigsCount = getXMLInt(xmlFile, "vehicle.Pigs#count");
    self.pigsRootNode = Utils.indexToObject(self.components, pigsIndex);
	
	local extraSeedBagsIndex = getXMLString(xmlFile, "vehicle.extraSeedBags#index");
    self.extraSeedBagsCount = getXMLInt(xmlFile, "vehicle.extraSeedBags#count");
    self.extraSeedBagsRootNode = Utils.indexToObject(self.components, extraSeedBagsIndex);
	
	local extraFertilizerBagsIndex = getXMLString(xmlFile, "vehicle.extraFertilizerBags#index");
    self.extraFertilizerBagsCount = getXMLInt(xmlFile, "vehicle.extraFertilizerBags#count");
    self.extraFertilizerBagsRootNode = Utils.indexToObject(self.components, extraFertilizerBagsIndex);
	--#
end;

function SmallTrailer:delete()
end;

function SmallTrailer:readStream(streamId, connection)
	if self.Animation ~= nil then
		local isAnimationPlayed = streamReadBool(streamId);
		self:setDoorAnimation(isAnimationPlayed, true);
	end;
end;

function SmallTrailer:writeStream(streamId, connection)
	if self.Animation ~= nil then
		streamWriteBool(streamId, self.isAnimationPlayed);
	end;
end;

function SmallTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SmallTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function SmallTrailer:update(dt)
	if self.inRange then
		if self.tipState == Trailer.TIPSTATE_CLOSED then
			if self.Animation ~= nil then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:setDoorAnimation(not self.isAnimationPlayed);
				end;
			g_currentMission:addHelpButtonText(g_i18n:getText("open/close"), InputBinding.IMPLEMENT_EXTRA2);
			end;
		else
			g_currentMission:addExtraPrintText(g_i18n:getText("wait"));
		end;
	end;
end;

function SmallTrailer:draw()

end;

function SmallTrailer:updateTick(dt)
	if g_currentMission.player then
		local maxDistance = 1.2
		local ax, ay, az = getWorldTranslation(self.referencesObject);
		local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(ax-px, ay-py, az-pz);
		if distance <= maxDistance then
			self.inRange = true;
		else
			self.inRange = false;
		end;
	end;
	--#
	setVisibility(self.seedBagsRootNode, true); 
	setVisibility(self.fertilizerBagsRootNode, true); 
	setVisibility(self.pigsRootNode, true); 
	setVisibility(self.extraSeedBagsRootNode, true); 
	setVisibility(self.extraFertilizerBagsRootNode, true); 
	
	for i=1, self.seedBagsCount do
		local bags = getChildAt(self.seedBagsRootNode, i-1);
		setVisibility(bags, false);
	end;
	
	for i=1, self.fertilizerBagsCount do
		local bagf = getChildAt(self.fertilizerBagsRootNode, i-1);
		setVisibility(bagf, false);
	end;
	
	for i=1, self.pigsCount do
		local pig = getChildAt(self.pigsRootNode, i-1);
		setVisibility(pig, false);
	end;
	
	for i=1, self.extraSeedBagsCount do
		local ebags = getChildAt(self.extraSeedBagsRootNode, i-1);
		setVisibility(ebags, false);
	end;
	
	for i=1, self.extraFertilizerBagsCount do
		local ebagf = getChildAt(self.extraFertilizerBagsRootNode, i-1);
		setVisibility(ebagf, false);
	end;
	percentDecimal = self.fillLevel/self.capacity;
	
	if self.varBody.activeIdx == 1 then
		if self.currentFillType == Fillable.FILLTYPE_SEEDS then
			self.seedBagsToShow = math.ceil(self.seedBagsCount*percentDecimal);
			for i=1, self.seedBagsToShow do
				local bags = getChildAt(self.seedBagsRootNode, i-1);
				setVisibility(bags, true);
			end;
		end;
		if self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
			self.fertilizerBagsToShow = math.ceil(self.fertilizerBagsCount*percentDecimal);
			for i=1, self.fertilizerBagsToShow do
				local bagf = getChildAt(self.fertilizerBagsRootNode, i-1);
				setVisibility(bagf, true);
			end;
		end;
	elseif self.varBody.activeIdx == 2 then
		if self.currentFillType == Fillable.FILLTYPE_PIG then
			self.pigsToShow = math.ceil(self.pigsCount*percentDecimal);
			for i=1, self.pigsToShow do
				local pig = getChildAt(self.pigsRootNode, i-1);
				setVisibility(pig, true);
			end;
		end;
	elseif self.varBody.activeIdx == 3 then
		if self.currentFillType == Fillable.FILLTYPE_SEEDS then
			self.extraSeedBagsToShow = math.ceil(self.extraSeedBagsCount*percentDecimal);
			for i=1, self.extraSeedBagsToShow do
				local ebags = getChildAt(self.extraSeedBagsRootNode, i-1);
				setVisibility(ebags, true);
			end;
		end;
		if self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
			self.extraFertilizerBagsToShow = math.ceil(self.extraFertilizerBagsCount*percentDecimal);
			for i=1, self.extraFertilizerBagsToShow do
				local ebagf = getChildAt(self.extraFertilizerBagsRootNode, i-1);
				setVisibility(ebagf, true);
			end;
		end;
	end;
	--#
end;

function SmallTrailer:setDoorAnimation(isAnimationPlayed, noEventSend)
	self.isAnimationPlayed = isAnimationPlayed;
	SmallTrailerEvent.sendEvent(self, isAnimationPlayed, noEventSend)
	if self.Animation ~= nil and self.playAnimation ~= nil then
		if isAnimationPlayed then
			self:playAnimation(self.Animation, self.AnimationSpeed, nil, true);
		else
			self:playAnimation(self.Animation, -self.AnimationSpeed, nil, true);
		end;
	end;
end;

SmallTrailerEvent = {};
SmallTrailerEvent_mt = Class(SmallTrailerEvent, Event);

InitEventClass(SmallTrailerEvent, "SmallTrailerEvent", EventIds.EVENT_SMALL_TRAILER);

function SmallTrailerEvent:emptyNew()
    local self = Event:new(SmallTrailerEvent_mt);
    return self;
end;

function SmallTrailerEvent:new(object, isAnimationPlayed)
    local self = SmallTrailerEvent:emptyNew()
    self.object = object;
    self.isAnimationPlayed = isAnimationPlayed;
    return self;
end;

function SmallTrailerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.isAnimationPlayed = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SmallTrailerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.isAnimationPlayed);
end;

function SmallTrailerEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object);
    end;
    if self.object ~= nil then
        self.object:setDoorAnimation(self.isAnimationPlayed, true);
    end;
end;

function SmallTrailerEvent.sendEvent(vehicle, isAnimationPlayed, noEventSend)
    if isAnimationPlayed ~= vehicle.isAnimationPlayed then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SmallTrailerEvent:new(vehicle, isAnimationPlayed), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SmallTrailerEvent:new(vehicle, isAnimationPlayed));
            end;
        end;
    end;
end;
