-- author: rafftnix
-- date: 16.12.2012


SetSawIsTurningEvent = {};
SetSawIsTurningEvent_mt = Class(SetSawIsTurningEvent, Event);
InitEventClass(SetSawIsTurningEvent, "SetSawIsTurningEvent");
function SetSawIsTurningEvent:emptyNew()
    local self = Event:new(SetSawIsTurningEvent_mt);
    self.className="SetSawIsTurningEvent";
    return self;
end;

function SetSawIsTurningEvent:new(object, isTurning)
    local self = SetSawIsTurningEvent:emptyNew(); 
    self.object = object; 
	self.isTurning = isTurning;
    return self;
end;

function SetSawIsTurningEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.isTurning);
end;

function SetSawIsTurningEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.isTurning = streamReadBool(streamId);
    self:run(connection);
end;

function SetSawIsTurningEvent:run(connection)
	self.object:setSawIsTurning(self.isTurning, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSawIsTurningEvent:new(self.object, self.isTurning), nil, connection, self.object);
	end; 
end;

function SetSawIsTurningEvent.sendEvent(object, isTurning, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(SetSawIsTurningEvent:new(object, isTurning), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(SetSawIsTurningEvent:new(object, isTurning)); 
		end;
	end;
end;