-- by "Marhu" 
-- v 1.0
-- Date: 21.05.2013
-- "Script zum entladen von Stckgut"

Cargo = {};

function Cargo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Cargo:load(xmlFile)
	self.updateTipping = Utils.overwrittenFunction(self.updateTipping, Cargo.updateTipping);
	self.CargoUnloadTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.GargoUnloadTime#value"), 1000);
end;

function Cargo:delete()
end;

function Cargo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Cargo:keyEvent(unicode, sym, modifier, isDown)
end;

function Cargo:update(dt)
end;

function Cargo:updateTipping(superFunc, dt)
	if not self.isServer then
		return;
	end;
	if self.varBody.activeIdx == 2 then -- Active only when trailer is ready for load pigs // Adam 334
		if self:getCanTip() then
			local fillType = self.currentFillType;
	   
			local fillDelta = -self.fillLevel;
			if self.currentTipReferencePointIndex ~= nil then
				local animation = self.tipAnimations[self.currentTipReferencePointIndex];
				if animation ~= nil and animation.dischargeEndTime > animation.dischargeStartTime then
					if self:getCurrentTipAnimationTime() >= animation.dischargeStartTime then
						local m = self.capacity/((animation.dischargeEndTime-animation.dischargeStartTime)/animation.animationOpenSpeedScale);
						fillDelta = -m * dt;
					else
						fillDelta = 0;
					end
				end
			end
	   
			if fillDelta < 0 then
				fillDelta = -1
				self.LoadTime = (self.LoadTime or 0) + dt
				if self.LoadTime >= self.CargoUnloadTime then
					self.LoadTime = 0
					local curFill = self.fillLevel;
					self:setFillLevel(self.fillLevel + fillDelta, fillType);
					local fillDelta = self.fillLevel - curFill;
					self.lastFillDelta = fillDelta;
		   
					if self.currentTipTrigger ~= nil then
						if self.currentTipTrigger.updateTrailerTipping ~= nil then
							self.currentTipTrigger:updateTrailerTipping(self, fillDelta, fillType);
						end
					elseif self:getCanTipToGround() then
						if fillDelta < 0 then
							local x, _,z = getWorldTranslation(self.groundDropArea.start);
							local x1,_,z1 = getWorldTranslation(self.groundDropArea.width);
							local x2,_,z2 = getWorldTranslation(self.groundDropArea.height);
		   
							local area = {x,z,x1,z1,x2,z2, -fillDelta*self.fillLevelToTippedFillLevel};
							local area, bitType, valueAccumulation = TrailerTipAreaEvent.runLocally(area, fillType, self.groundAmountAccumulation)
							if area ~= nil then
								g_server:broadcastEvent(TrailerTipAreaEvent:new(area, bitType, fillType));
							end;
							if valueAccumulation ~= nil then
								self.groundAmountAccumulation = valueAccumulation;
							end;
						end;
					end;
				end;
			end;
		else
			self:onEndTip();
		end;
	end;
end

function Cargo:draw()
end;